package de.christofreichardt.scala.krypto.algorithms

import de.christofreichardt.scala.krypto.MyFunSuite

class PrimeFactorizationSuite extends MyFunSuite {
  
	testWithTracing(this, "fullFactorization") {
	  val tracer = getCurrentTracer
	  val testVector = List(BigInt("13664"), BigInt("103950423311769222322436574229183"), BigInt("359193588086672379581820967393863427121420409812439911"))
	  assert(testVector.forall(test => {
	    val primeFactorization = new PrimeFactorization(test)
	    tracer.out().printfIndentln("PrimeFactors(%s) = %s", test, primeFactorization.outcome)
	    primeFactorization.crossCheck
	  }))
	}
	
	testWithTracing(this, "partialFactorization") {
	  val tracer = getCurrentTracer
	  val testVector = List(BigInt("115949242888388853456201369291688761725737302955395356485651"),
	      BigInt("6813455260309801574147255321369106810893081690071382038409"))
	  assert(testVector.forall(test => {
	    val primeFactorization = new PrimeFactorization(test)
	    tracer.out().printfIndentln("PrimeFactors(%s) = %s", test, primeFactorization.outcome)
	    primeFactorization.crossCheck || primeFactorization.productCheck
	  }))
	}
}