package de.christofreichardt.scala.krypto.algorithms

import de.christofreichardt.scala.krypto.MyFunSuite

class PMinusOneSuite extends MyFunSuite {

  testWithTracing(this, "factorize") {
    val tracer = getCurrentTracer
    val testVector = List(/*BigInt(11)*BigInt(59),*/
        BigInt("3585826326716903923679181287673440225050708704133241865988730115291769995138312905967557728522661122992781217713847323"),
        BigInt(92387)*BigInt(319313))
     assert(testVector.forall(test => {
       tracer.out().printfIndentln("test = %s", test)
       val pMinusOneMethod = new PMinusOneMethod(test)
       tracer.out().printfIndentln("%s | %s", pMinusOneMethod.outcome, test)
       pMinusOneMethod.crossCheck
     }))
  }
}