package de.christofreichardt.scala.krypto.algorithms

import de.christofreichardt.scala.krypto.MyFunSuite

class LinearCongruenceSuite extends MyFunSuite {
  
	testWithTracing(this, "uniqueSolution") {
	  val testVector = List((BigInt(35),BigInt(3094),BigInt(32586)))
	  assert(testVector.forall(test => {
	    val solver = new LinearCongruence(test)
	    solver.crossCheck
	  }))
	}
  
	testWithTracing(this, "emptySolutionSet") {
	  val testVector = List((BigInt(10),BigInt(13),BigInt(35)))
	  assert(testVector.forall(test => {
	    val solver = new LinearCongruence(test)
	    solver.crossCheck
	  }))
	}
  
	testWithTracing(this, "multipleSolutions") {
	  val testVector = List((BigInt(980),BigInt(52),BigInt(5672)))
	  assert(testVector.forall(test => {
	    val solver = new LinearCongruence(test)
	    solver.crossCheck
	  }))
	}
	
}