package de.christofreichardt.scala.krypto.algorithms

import de.christofreichardt.scala.krypto.MyFunSuite
import scala.util.Random
import de.christofreichardt.scala.krypto.PrimeBase

class GeneratorSearchSuite extends MyFunSuite {
	
  testWithTracing(this, "orderOfElement") {
    val tracer = getCurrentTracer
    val testVector = List((67,12101), (938,481147))
    assert(testVector.forall(test => {
      tracer.out().printfIndentln("test = %s", test)
      val primeFactorization = new PrimeFactorization(test._2 - 1)
      val orderOfElement = new OrderOfElement(test._1, test._2, primeFactorization.outcome)
      tracer.out().printfIndentln("%s^%s = 1 (mod %s)", BigInt(test._1), orderOfElement.outcome, BigInt(test._2))
      orderOfElement.crossCheck
    }))
  }
  
  testWithTracing(this, "generator") {
    val tracer = getCurrentTracer
    val random = new Random
    val randomPrime = PrimeBase.primes(random.nextInt(PrimeBase.primes.size - 100) + 100)
    val testVector = List(BigInt(31), BigInt(449), BigInt(6353), BigInt(33107), BigInt(541547), BigInt(randomPrime))
    assert(testVector.forall(test => {
      tracer.out().printfIndentln("test = %s", test)
      val generatorSearch = new GeneratorSearch(test)
      tracer.out().printfIndentln("generatorSearch.outcome = %s", generatorSearch.outcome)
      generatorSearch.crossCheck
    }))
  }

}