package de.christofreichardt.scala.krypto.algorithms

import org.scalatest.BeforeAndAfterAll
import de.christofreichardt.scala.diagnosis.Tracing
import org.scalatest.FunSuite
import org.scalatest.Args
import de.christofreichardt.diagnosis.AbstractTracer
import de.christofreichardt.diagnosis.TracerFactory
import org.scalatest.Status
import de.christofreichardt.scala.krypto.MyFunSuite

class EratosthenesSuite extends MyFunSuite {

  override def afterAll: Unit = {
    withTracer("Unit", this, "afterAll") {}
  }

  testWithTracing(this, "IterativeSieve") {
    val testVector = List((100,25), (500,95), (1000,168), (5000,669), (10000,1229), (50000,5133), (100000,9592))
    assert(testVector.forall(test => {
      val eratosthenes = new SieveOfEratosthenes(test._1)
		  val tracer = getCurrentTracer
		  tracer.out().printfIndentln("eratosthenes.outcome.length = %d", int2Integer(eratosthenes.outcome.length))
      eratosthenes.crossCheck && eratosthenes.outcome.length == test._2
    }))
  }
}