package de.christofreichardt.scala.krypto.algorithms

import de.christofreichardt.scala.krypto.MyFunSuite
import de.christofreichardt.scala.krypto.DLProblem
import scala.util.Random

class DLSuite extends MyFunSuite {
	
  testWithTracing(this, "enumeration") {
    val tracer = getCurrentTracer
    val testVector = List(new DLProblem(5,6,7,6), new DLProblem(67,9483,12101,12100))
    assert(testVector.forall(test => {
      val enumerationAlgo = new EnumerationAlgo(test)
      tracer.out().printfIndentln("Solution(%s) = %s", enumerationAlgo, enumerationAlgo.outcome)
      enumerationAlgo.crossCheck
    }))
  }
  
  testWithTracing(this, "babyStepGiantStep") {
    val tracer = getCurrentTracer
    val testVector = List(new DLProblem(11,3,29,28), new DLProblem(4,17,19,9), new DLProblem(67,9483,12101,12100))
    assert(testVector.forall(test => {
      val babyStepGiantStep = new BabyStepGiantStep(test)
      tracer.out().printfIndentln("Solution(%s) = %s", babyStepGiantStep, babyStepGiantStep.outcome)
      babyStepGiantStep.crossCheck
    }))
  }
  
  testWithTracing(this, "pollardRho") {
    val tracer = getCurrentTracer
    val testVector = List(new DLProblem(5,3,2017,2016), new DLProblem(67,9483,12101,12100))
    assert(testVector.forall(test => {
      val pollardRho = new PollardRho(test)
      tracer.out().printfIndentln("Solution(%s) = %s", pollardRho, pollardRho.outcome)
      pollardRho.outcome
      pollardRho.crossCheck
    }))
  }
  
  testWithTracing(this, "emptySolutionSet") {
    val tracer = getCurrentTracer
    val testVector = List(new DLProblem(4,15,19,9))
    testVector.foreach(test => {
      val babyStepGiantStep = new BabyStepGiantStep(test)
      tracer.out().printfIndentln("Solution(%s) = %s", babyStepGiantStep, babyStepGiantStep.outcome)
      intercept[IllegalArgumentException] {
      	babyStepGiantStep.crossCheck
      }
    })
  }
  
  testWithTracing(this, "pohligHellmanWithEnumeration") {
    val tracer = getCurrentTracer
    val testVector = List(new DLProblem(67,9483,12101,12100))
    assert(testVector.forall(test => {
      val pohligHellmanWithEnumeration = new PohligHellmanWithEnumeration(test)
      tracer.out().printfIndentln("Solution(%s) = %s", pohligHellmanWithEnumeration, pohligHellmanWithEnumeration.outcome)
      pohligHellmanWithEnumeration.crossCheck
    }))
  }
  
  testWithTracing(this, "pohligHellmanWithBSGS") {
    val tracer = getCurrentTracer
    val testVector = List(new DLProblem(67,9483,12101,12100), new DLProblem(BigInt("5"),BigInt("101"),BigInt("6766311759093979123"),BigInt("6766311759093979122")))
    assert(testVector.forall(test => {
      val pohligHellmanWithBSGS = new PohligHellmanWithBSGS(test)
      tracer.out().printfIndentln("Solution(%s) = %s", pohligHellmanWithBSGS, pohligHellmanWithBSGS.outcome)
      pohligHellmanWithBSGS.crossCheck
    }))
  }
  
  testWithTracing(this, "pohligHellmanWithPollardRho") {
    val tracer = getCurrentTracer
    val testVector = List(
        new DLProblem(67,9483,12101,12100), 
        new DLProblem(BigInt("5"),BigInt("101"),BigInt("6766311759093979123"),BigInt("6766311759093979122")),
        {
          val prime: BigInt = 697979
          val generatorSearch = new GeneratorSearch(prime)
          assert(generatorSearch.crossCheck)
          new DLProblem(generatorSearch.outcome, BigInt(78326), prime, prime - 1)
        },
        {
          val prime: BigInt = 987013
          val generator: BigInt = 504512
          val random = new Random
          val b = random.nextInt(prime.toInt - 1) + 1
          new DLProblem(generator, b, prime, prime - 1)
        }
        )
    assert(testVector.forall(test => {
      val pohligHellmanWithPollardRho = new PohligHellmanWithPollardRho(test)
      tracer.out().printfIndentln("test = %s", pohligHellmanWithPollardRho)
      tracer.out().printfIndentln("Solution(%s) = %s", pohligHellmanWithPollardRho, pohligHellmanWithPollardRho.outcome)
      pohligHellmanWithPollardRho.crossCheck
    }))
  }
}