package de.christofreichardt.scala.krypto.algorithms

import org.scalatest.Args
import org.scalatest.BeforeAndAfterAll
import org.scalatest.FunSuite
import org.scalatest.Status
import de.christofreichardt.diagnosis.AbstractTracer
import de.christofreichardt.diagnosis.TracerFactory
import de.christofreichardt.scala.diagnosis.Tracing
import de.christofreichardt.scala.krypto.MyFunSuite

class CRTSuite() extends MyFunSuite {

  override def afterAll: Unit = {
    withTracer("Unit", this, "afterAll") {}
  }
  
  testWithTracing(this, "IllegalModuli") {
    val equations = List((BigInt(2),BigInt(3)), (BigInt(3),BigInt(4)), (BigInt(1),BigInt(8)))
    intercept[IllegalArgumentException] {
      val algo = new ChineseRemainderTheorem(equations)
    }
  }
  
  testWithTracing(this, "CommonModulus") {
    val equations = List((BigInt(2),BigInt(3)), (BigInt(3),BigInt(4)), (BigInt(1),BigInt(5)))
    val algo = new ChineseRemainderTheorem(equations)
    assert(algo.modulus == BigInt(60))
  }
  
  testWithTracing(this, "Equation_1") {
    val equations = List((BigInt(2),BigInt(3)), (BigInt(3),BigInt(4)), (BigInt(1),BigInt(5)))
    val algo = new ChineseRemainderTheorem(equations)
    assert(algo.outcome == BigInt(11))
    assert(algo.crossCheck)
  }
  
  testWithTracing(this, "Equation_2") {
    val equations = List((BigInt(2),BigInt(3)), (BigInt(3),BigInt(4)), (BigInt(2),BigInt(5)))
    val algo = new ChineseRemainderTheorem(equations)
    assert(algo.outcome == BigInt(47))
    assert(algo.crossCheck)
  }
}