package de.christofreichardt.scala.krypto

class PrimeBaseSuite extends MyFunSuite {
  
	testWithTracing(this, "PrimeBase") {
	  val testVector = List((100,25), (500,95), (1000,168), (5000,669), (10000,1229), (50000,5133), (100000,9592), (500000,41538), (1000000,78498))
	  assert(testVector.forall(test => {
		  val tracer = getCurrentTracer
		  tracer.out().printfIndentln("primes < %1$d == %2$d", int2Integer(test._1), int2Integer(test._2))
	    PrimeBase.primes.filter(prime => prime < test._1).size == test._2
	  }))
	}
	
}