package de.christofreichardt.scala.krypto

import org.scalatest.BeforeAndAfterAll
import de.christofreichardt.scala.diagnosis.Tracing
import org.scalatest.FunSuite
import org.scalatest.Args
import org.scalatest.Status
import de.christofreichardt.diagnosis.AbstractTracer
import de.christofreichardt.diagnosis.TracerFactory
import de.christofreichardt.diagnosis.LogLevel

class MyFunSuite extends FunSuite with Tracing with BeforeAndAfterAll {

  override def run(testName: Option[String], args: Args): Status = {
    printf("%s.run%n", this.getClass().getSimpleName())
    val tracer = getCurrentTracer
    tracer.initCurrentTracingContext(15, true)
    withTracer("Status", this, "run(testName: Option[String], args: Args)") {
    	tracer.out().printfIndentln("testName = %s", testName)
    	tracer.out().printfIndentln("this.suiteName = %s", this.suiteName)
    	tracer.out().printfIndentln("args = %s", args)
    	super.run(testName, args)
    }
  }
  
  override def beforeAll(): Unit = {
   val tracer = getCurrentTracer
   tracer.logMessage(LogLevel.INFO, this.suiteName + " started ...", getClass(), "beforeAll()")
  }
  
  override def getCurrentTracer(): AbstractTracer = {
    try {
      TracerFactory.getInstance().getTracer("TestTracer")
    }
    catch {
      case ex: TracerFactory.Exception => TracerFactory.getInstance().getDefaultTracer
    }
  }
  
  def testWithTracing[T](callee : Any, testName : String)(block : => T) : Unit = {
    test(testName) {
      withTracer("Unit", this, testName) {
        block
      }
    }
  }
}