package de.christofreichardt.scala.krypto

import java.io.File

import de.christofreichardt.diagnosis.TracerFactory
import de.christofreichardt.scala.diagnosis.Tracing

object Main extends Tracing {
	def main(args: Array[String]): Unit = {
	  TracerFactory.getInstance().readConfiguration(new File("." + File.separator + "config" + File.separator + "tracerfactory-config.xml"))
	  TracerFactory.getInstance().openPoolTracer()
	  try {
	    val tracer = getCurrentTracer
	    tracer.initCurrentTracingContext()
	    withTracer("Unit", this, "args: Array[String]") {
	      val propertyNames = System.getProperties().stringPropertyNames.toArray(new Array[String](0)).sorted
	      propertyNames.foreach(propertyName => tracer.out().printfIndentln("%s = %s", propertyName, System.getProperty(propertyName)))
	    }
	  }
	  finally {
	    TracerFactory.getInstance().closePoolTracer()
	  }
	}
}