package de.christofreichardt.scala.krypto

import de.christofreichardt.scala.diagnosis.Tracing
import java.io.FileInputStream
import java.io.BufferedInputStream
import java.io.DataInputStream
import java.io.File

class LCMIterator(dataInputStream: DataInputStream) extends Iterator[BigInt] with Tracing {
  var currentLength: Int = _
  
  def hasNext: Boolean = {
    try {
      currentLength = dataInputStream.readInt()
      true
    }
    catch {
      case ex: java.io.IOException => false
    }
  }
  
  def next: BigInt = {
    val byteBuffer: Array[Byte] = new Array(currentLength)
  	dataInputStream.read(byteBuffer, 0, currentLength)
  	BigInt(byteBuffer)
  }
}

object LCMBase extends Tracing {
  
  val lcms = deserializeLCMs()

  def deserializeLCMs(): Seq[BigInt] = {
    withTracer("Seq[BigInt]", this, "deserializeCs(fileName: String)") {
      val tracer = getCurrentTracer()
      
      val lcmFile = new File("." + File.separator + "LCMBase.bin")
      val fileInputStream = new FileInputStream(lcmFile)
      try {
	      val bufferedInputStream = new BufferedInputStream(fileInputStream)
	      val dataInputStream = new DataInputStream(bufferedInputStream)
	      val iter = new LCMIterator(dataInputStream)
        val lcms = iter.toList
        tracer.out().printfIndentln("lcms.length = %d", int2Integer(lcms.length))
        lcms
      }
      finally {
        fileInputStream.close()
      }
    }
  }
}