/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis.io;

import de.christofreichardt.diagnosis.AbstractThreadMap;
import de.christofreichardt.diagnosis.ThreadLocalMap;
import de.christofreichardt.diagnosis.io.Indentable;
import de.christofreichardt.diagnosis.io.IndentablePrintStream;
import de.christofreichardt.diagnosis.io.NullOutputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class TracePrintStream
extends IndentablePrintStream {
    public static final int MAX_INDENT_NUMBER = 100;
    public static final int INDENT_CHAR_NUMBER = 2;
    protected static final String[] INDENT_STRING = new String[100];
    protected final AbstractThreadMap threadMap;

    public TracePrintStream() {
        super(new NullOutputStream());
        this.threadMap = new ThreadLocalMap();
    }

    public TracePrintStream(OutputStream out, AbstractThreadMap threadMap) {
        super(out);
        this.threadMap = threadMap;
    }

    @Override
    public IndentablePrintStream printIndent(String s) {
        this.printIndentString();
        this.print(s);
        return this;
    }

    @Override
    public IndentablePrintStream printIndentln(String s) {
        this.printIndentString();
        this.println(s);
        return this;
    }

    @Override
    public IndentablePrintStream printIndentString() {
        int level = this.threadMap.getCurrentStackSize();
        if (level < 0) {
            System.err.println("ERROR: Trace stream unlocked but no stack!");
        } else if (level >= 0 && level < 100) {
            this.print(INDENT_STRING[level]);
        } else {
            this.print(INDENT_STRING[99]);
        }
        return this;
    }

    @Override
    public Indentable printfIndentln(String format, Object ... args) {
        this.printIndentString();
        this.printf(format, args);
        this.println();
        return this;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            char[] spaces = new char[i * 2];
            Arrays.fill(spaces, ' ');
            TracePrintStream.INDENT_STRING[i] = new String(spaces);
        }
    }
}

