/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.krypto.algorithms;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.scala.krypto.Constants$;
import de.christofreichardt.scala.krypto.PrimeBase$;
import de.christofreichardt.scala.krypto.algorithms.Algorithm;
import de.christofreichardt.scala.krypto.algorithms.PrimeFactorization$;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.SeqView$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u001b\t\u0011\u0002K]5nK\u001a\u000b7\r^8sSj\fG/[8o\u0015\t\u0019A!\u0001\u0006bY\u001e|'/\u001b;i[NT!!\u0002\u0004\u0002\r-\u0014\u0018\u0010\u001d;p\u0015\t9\u0001\"A\u0003tG\u0006d\u0017M\u0003\u0002\n\u0015\u0005\t2\r\u001b:jgR|gM]3jG\"\f'\u000f\u001a;\u000b\u0003-\t!\u0001Z3\u0004\u0001M\u0011\u0001A\u0004\t\u0005\u001fA\u0011r$D\u0001\u0003\u0013\t\t\"AA\u0005BY\u001e|'/\u001b;i[B\u00111\u0003\b\b\u0003)eq!!\u0006\r\u000e\u0003YQ!a\u0006\u0007\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0011B\u0001\u000e\u001c\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aB\u0005\u0003;y\u0011aAQ5h\u0013:$(B\u0001\u000e\u001c!\r\u0019\u0002EI\u0005\u0003Cy\u0011A\u0001T5tiB!1\u0005\n\n'\u001b\u0005Y\u0012BA\u0013\u001c\u0005\u0019!V\u000f\u001d7feA\u00111eJ\u0005\u0003Qm\u00111!\u00138u\u0011!Q\u0003A!b\u0001\n\u0003Y\u0013A\u00028v[\n,'/F\u0001\u0013\u0011!i\u0003A!A!\u0002\u0013\u0011\u0012a\u00028v[\n,'\u000f\t\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005E\u0012\u0004CA\b\u0001\u0011\u0015Qc\u00061\u0001\u0013\u0011\u001d!\u0004A1A\u0005\u0002U\n1\"\\1y\u000bb\u0004xN\\3oiV\ta\u0005\u0003\u00048\u0001\u0001\u0006IAJ\u0001\r[\u0006DX\t\u001f9p]\u0016tG\u000f\t\u0005\u0006s\u0001!IAO\u0001\nM\u0006\u001cGo\u001c:ju\u0016$BaH\u001e>\u007f!)A\b\u000fa\u0001%\u0005\ta\u000eC\u0003?q\u0001\u0007q$A\u0004gC\u000e$xN]:\t\u000b\u0001C\u0004\u0019A!\u0002\rA\u0014\u0018.\\3t!\r\u0019\u0002E\n\u0015\u0003q\r\u0003\"\u0001R$\u000e\u0003\u0015S!AR\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002I\u000b\n9A/Y5me\u0016\u001c\u0007\"\u0002&\u0001\t#Y\u0015!C2bY\u000e,H.\u0019;f)\u0005y\u0002\u0002C'\u0001\u0011\u000b\u0007I\u0011\u0001(\u0002\u0019A\u0014x\u000eZ;di\u000eCWmY6\u0016\u0003=\u0003\"a\t)\n\u0005E[\"a\u0002\"p_2,\u0017M\u001c\u0005\t'\u0002A\t\u0011)Q\u0005\u001f\u0006i\u0001O]8ek\u000e$8\t[3dW\u0002B\u0001\"\u0016\u0001\t\u0006\u0004%\tAT\u0001\u000baJLW.Z\"iK\u000e\\\u0007\u0002C,\u0001\u0011\u0003\u0005\u000b\u0015B(\u0002\u0017A\u0014\u0018.\\3DQ\u0016\u001c7\u000e\t\u0005\u00063\u0002!\tEW\u0001\u000bGJ|7o]\"iK\u000e\\G#A(\t\u000bq\u0003A\u0011I/\u0002!\u001d,GoQ;se\u0016tG\u000f\u0016:bG\u0016\u0014H#\u00010\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005D\u0011!\u00033jC\u001etwn]5t\u0013\t\u0019\u0007M\u0001\bBEN$(/Y2u)J\f7-\u001a:")
public class PrimeFactorization
extends Algorithm<BigInt, List<Tuple2<BigInt, Object>>> {
    private final BigInt number;
    private final int maxExponent;
    private boolean productCheck;
    private boolean primeCheck;
    private volatile byte bitmap$0;

    private boolean productCheck$lzycompute() {
        PrimeFactorization primeFactorization = this;
        synchronized (primeFactorization) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.productCheck = BoxesRunTime.equals((Object)((LinearSeqOptimized)this.outcome()).foldLeft((Object)package$.MODULE$.BigInt().apply(1), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BigInt apply(BigInt r, Tuple2<BigInt, Object> c) {
                        return r.$times(((BigInt)c._1()).pow(c._2$mcI$sp()));
                    }
                }), (Object)this.number());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.productCheck;
        }
    }

    private boolean primeCheck$lzycompute() {
        PrimeFactorization primeFactorization = this;
        synchronized (primeFactorization) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.primeCheck = ((LinearSeqOptimized)this.outcome()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<BigInt, Object> primePower) {
                        return ((BigInt)primePower._1()).isProbablePrime(Constants$.MODULE$.certainty());
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.primeCheck;
        }
    }

    public BigInt number() {
        return this.number;
    }

    public int maxExponent() {
        return this.maxExponent;
    }

    public List<Tuple2<BigInt, Object>> de$christofreichardt$scala$krypto$algorithms$PrimeFactorization$$factorize(BigInt n, List<Tuple2<BigInt, Object>> factors, List<Object> primes) {
        while (true) {
            List nextFactors;
            BigInt next;
            block8: {
                List list;
                block7: {
                    block6: {
                        List list2;
                        int exponent = this.checkPrime$1(BoxesRunTime.unboxToInt((Object)primes.head()), n);
                        BigInt primePower = package$.MODULE$.BigInt().apply(BoxesRunTime.unboxToInt((Object)primes.head())).pow(exponent);
                        next = n.$div(primePower);
                        if (exponent != 0) {
                            Tuple2 tuple2 = new Tuple2((Object)package$.MODULE$.BigInt().apply(BoxesRunTime.unboxToInt((Object)primes.head())), (Object)BoxesRunTime.boxToInteger((int)exponent));
                            list2 = factors.$colon$colon((Object)tuple2);
                        } else {
                            list2 = nextFactors = factors;
                        }
                        if (!BoxesRunTime.equalsNumNum((Number)next, (Number)package$.MODULE$.BigInt().apply(1))) break block6;
                        list = nextFactors;
                        break block7;
                    }
                    Object object = primes.tail();
                    Nil$ nil$ = Nil$.MODULE$;
                    if (object != null ? !object.equals(nil$) : nil$ != null) break block8;
                    Tuple2 tuple2 = new Tuple2((Object)next, (Object)BoxesRunTime.boxToInteger((int)1));
                    list = nextFactors.$colon$colon((Object)tuple2);
                }
                return list;
            }
            primes = (List)primes.tail();
            factors = nextFactors;
            n = next;
        }
    }

    @Override
    public List<Tuple2<BigInt, Object>> calculate() {
        return (List)this.withTracer("List[Tuple2[BigInt,Int]]", this, "calculate()", new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimeFactorization $outer;

            public final List<Tuple2<BigInt, Object>> apply() {
                return this.$outer.de$christofreichardt$scala$krypto$algorithms$PrimeFactorization$$factorize(this.$outer.number(), (List<Tuple2<BigInt, Object>>)List$.MODULE$.empty(), (List<Object>)PrimeBase$.MODULE$.primes().view().takeWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$calculate$1 $outer;

                    public final boolean apply(int prime) {
                        return this.apply$mcZI$sp(prime);
                    }

                    public boolean apply$mcZI$sp(int prime) {
                        return package$.MODULE$.BigInt().apply(prime).$times(package$.MODULE$.BigInt().apply(prime)).$less$eq(this.$outer.de$christofreichardt$scala$krypto$algorithms$PrimeFactorization$$anonfun$$$outer().number());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).toList());
            }

            public /* synthetic */ PrimeFactorization de$christofreichardt$scala$krypto$algorithms$PrimeFactorization$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean productCheck() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.productCheck$lzycompute() : this.productCheck;
    }

    public boolean primeCheck() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.primeCheck$lzycompute() : this.primeCheck;
    }

    @Override
    public boolean crossCheck() {
        return BoxesRunTime.unboxToBoolean(this.withTracer("Boolean", this, "crossCheck()", new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimeFactorization $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.productCheck() && this.$outer.primeCheck();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        AbstractTracer abstractTracer;
        try {
            abstractTracer = TracerFactory.getInstance().getTracer("TestTracer");
        }
        catch (TracerFactory.Exception exception) {
            abstractTracer = TracerFactory.getInstance().getDefaultTracer();
        }
        return abstractTracer;
    }

    private final int checkPrime$1(int p, BigInt n$1) {
        Range exponents = package$.MODULE$.Range().apply(0, this.maxExponent());
        int exponent = ((GenSeqLike)exponents.view().map((Function1)new Serializable(this, p){
            public static final long serialVersionUID = 0L;
            private final int p$1;

            public final BigInt apply(int exponent) {
                return package$.MODULE$.BigInt().apply(this.p$1).pow(exponent);
            }
            {
                this.p$1 = p$1;
            }
        }, SeqView$.MODULE$.canBuildFrom())).indexWhere((Function1)new Serializable(this, n$1){
            public static final long serialVersionUID = 0L;
            private final BigInt n$1;

            public final boolean apply(BigInt power) {
                return !BoxesRunTime.equalsNumObject((Number)this.n$1.$percent(power), (Object)BoxesRunTime.boxToInteger((int)0));
            }
            {
                this.n$1 = n$1;
            }
        }) - 1;
        return exponent;
    }

    public PrimeFactorization(BigInt number) {
        this.number = number;
        super(number);
        this.maxExponent = 4096;
    }
}

