/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.krypto.algorithms;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.scala.krypto.DLProblem;
import de.christofreichardt.scala.krypto.algorithms.DLAlgorithm;
import de.christofreichardt.scala.krypto.algorithms.LinearCongruence;
import de.christofreichardt.scala.krypto.algorithms.PollardRho$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.SetLike;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StreamIterator;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u001b\tQ\u0001k\u001c7mCJ$'\u000b[8\u000b\u0005\r!\u0011AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011QAB\u0001\u0007WJL\b\u000f^8\u000b\u0005\u001dA\u0011!B:dC2\f'BA\u0005\u000b\u0003E\u0019\u0007N]5ti>4'/Z5dQ\u0006\u0014H\r\u001e\u0006\u0002\u0017\u0005\u0011A-Z\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tYA\tT!mO>\u0014\u0018\u000e\u001e5n\u0011!\u0019\u0002A!A!\u0002\u0013!\u0012!\u00033m!J|'\r\\3n!\t)b#D\u0001\u0005\u0013\t9BAA\u0005E\u0019B\u0013xN\u00197f[\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\"a\u0007\u000f\u0011\u0005=\u0001\u0001\"B\n\u0019\u0001\u0004!\u0002b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0003IF*\u0012\u0001\t\t\u0003C\u0015j\u0011A\t\u0006\u0003G\u0011\nA!\\1uQ*\tq!\u0003\u0002'E\t1!)[4J]RDa\u0001\u000b\u0001!\u0002\u0013\u0001\u0013a\u000132A!9!\u0006\u0001b\u0001\n\u0003y\u0012A\u000133\u0011\u0019a\u0003\u0001)A\u0005A\u0005\u0019AM\r\u0011\t\u000b9\u0002A\u0011A\u0018\u0002#E,\u0018\r\u001a:va2,7+Z9vK:\u001cW\r\u0006\u00021\u0005B\u0019\u0011'\u000f\u001f\u000f\u0005I:dBA\u001a7\u001b\u0005!$BA\u001b\r\u0003\u0019a$o\\8u}%\tq!\u0003\u00029I\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001e<\u0005\u0019\u0019FO]3b[*\u0011\u0001\b\n\t\u0007{y\u0002\u0005\t\u0011!\u000e\u0003\u0011J!a\u0010\u0013\u0003\rQ+\b\u000f\\35!\t\t\u0014)\u0003\u0002'w!)1)\fa\u0001\u0001\u0006\u0011\u0001\u0010\r\u0005\u0006\u000b\u0002!IAR\u0001\u000fiJL\u0007\u000f\\3TKF,XM\\2f)\t\u0001t\tC\u0003I\t\u0002\u0007A(A\u0005rk\u0006$'/\u001e9mK\")!\n\u0001C\u0001\u0017\u0006q1/Z1sG\"4uN]'bi\u000eDGc\u0001'P3B!Q(\u0014!A\u0013\tqEE\u0001\u0004UkBdWM\r\u0005\u0006!&\u0003\r!U\u0001\u000bcV\fGM];qY\u0016\u001c\bc\u0001*Xy5\t1K\u0003\u0002U+\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003-\u0012\n!bY8mY\u0016\u001cG/[8o\u0013\tA6K\u0001\bTiJ,\u0017-\\%uKJ\fGo\u001c:\t\u000biK\u0005\u0019\u0001!\u0002\u0015%$XM]1uS>t7\u000fC\u0003]\u0001\u0011\u0005Q,A\u0005dC2\u001cW\u000f\\1uKR\ta\fE\u0002>?\u0002K!\u0001\u0019\u0013\u0003\r=\u0003H/[8o\u0001")
public class PollardRho
extends DLAlgorithm {
    private final BigInt d1 = this.p().$div(BigInt$.MODULE$.int2bigInt(3));
    private final BigInt d2 = this.p().$times(BigInt$.MODULE$.int2bigInt(2)).$div(BigInt$.MODULE$.int2bigInt(3));

    public BigInt d1() {
        return this.d1;
    }

    public BigInt d2() {
        return this.d2;
    }

    public Stream<Tuple4<BigInt, BigInt, BigInt, BigInt>> quadrupleSequence(BigInt x0) {
        return (Stream)this.withTracer("Stream[Tuple3[BigInt,BigInt,BigInt]]", this, "quadrupleSequence(x0: BigInt)", new Serializable(this, x0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PollardRho $outer;
            private final BigInt x0$1;

            public final Stream.Cons<Tuple4<BigInt, BigInt, BigInt, BigInt>> apply() {
                AbstractTracer tracer = this.$outer.getCurrentTracer();
                tracer.out().printfIndentln("x0 = %s", new Object[]{this.x0$1});
                Tuple4 quadruple = new Tuple4((Object)package$.MODULE$.BigInt().apply(0), (Object)this.$outer.a().modPow(this.x0$1, this.$outer.p()), (Object)this.x0$1, (Object)package$.MODULE$.BigInt().apply(0));
                tracer.out().printfIndentln("quadruple = %s", new Object[]{quadruple});
                return Stream.cons$.MODULE$.apply((Object)quadruple, (Function0)new Serializable(this, quadruple){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$quadrupleSequence$1 $outer;
                    private final Tuple4 quadruple$1;

                    public final Stream<Tuple4<BigInt, BigInt, BigInt, BigInt>> apply() {
                        return this.$outer.de$christofreichardt$scala$krypto$algorithms$PollardRho$$anonfun$$$outer().de$christofreichardt$scala$krypto$algorithms$PollardRho$$tripleSequence((Tuple4<BigInt, BigInt, BigInt, BigInt>)this.quadruple$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.quadruple$1 = quadruple$1;
                    }
                });
            }

            public /* synthetic */ PollardRho de$christofreichardt$scala$krypto$algorithms$PollardRho$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.x0$1 = x0$1;
            }
        });
    }

    public Stream<Tuple4<BigInt, BigInt, BigInt, BigInt>> de$christofreichardt$scala$krypto$algorithms$PollardRho$$tripleSequence(Tuple4<BigInt, BigInt, BigInt, BigInt> quadruple) {
        Tuple4 tuple4;
        AbstractTracer tracer = this.getCurrentTracer();
        BigInt index = ((BigInt)quadruple._1()).$plus(BigInt$.MODULE$.int2bigInt(1));
        if (((BigInt)quadruple._2()).$less(this.d1())) {
            BigInt betaNext = this.a().$times((BigInt)quadruple._2()).mod(this.p());
            BigInt xNext = ((BigInt)quadruple._3()).$plus(BigInt$.MODULE$.int2bigInt(1)).mod(this.p().$minus(BigInt$.MODULE$.int2bigInt(1)));
            BigInt yNext = (BigInt)quadruple._4();
            tuple4 = new Tuple4((Object)index, (Object)betaNext, (Object)xNext, (Object)yNext);
        } else if (((BigInt)quadruple._2()).$less(this.d2())) {
            BigInt betaNext = ((BigInt)quadruple._2()).$times((BigInt)quadruple._2()).mod(this.p());
            BigInt xNext = BigInt$.MODULE$.int2bigInt(2).$times((BigInt)quadruple._3()).mod(this.p().$minus(BigInt$.MODULE$.int2bigInt(1)));
            BigInt yNext = BigInt$.MODULE$.int2bigInt(2).$times((BigInt)quadruple._4()).mod(this.p().$minus(BigInt$.MODULE$.int2bigInt(1)));
            tuple4 = new Tuple4((Object)index, (Object)betaNext, (Object)xNext, (Object)yNext);
        } else {
            BigInt betaNext = this.b().$times((BigInt)quadruple._2()).mod(this.p());
            BigInt xNext = (BigInt)quadruple._3();
            BigInt yNext = ((BigInt)quadruple._4()).$plus(BigInt$.MODULE$.int2bigInt(1)).mod(this.p().$minus(BigInt$.MODULE$.int2bigInt(1)));
            tuple4 = new Tuple4((Object)index, (Object)betaNext, (Object)xNext, (Object)yNext);
        }
        Tuple4 nextQuadruple = tuple4;
        return Stream.cons$.MODULE$.apply((Object)nextQuadruple, (Function0)new Serializable(this, nextQuadruple){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PollardRho $outer;
            private final Tuple4 nextQuadruple$1;

            public final Stream<Tuple4<BigInt, BigInt, BigInt, BigInt>> apply() {
                return this.$outer.de$christofreichardt$scala$krypto$algorithms$PollardRho$$tripleSequence((Tuple4<BigInt, BigInt, BigInt, BigInt>)this.nextQuadruple$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.nextQuadruple$1 = nextQuadruple$1;
            }
        });
    }

    public Tuple2<BigInt, BigInt> searchForMatch(StreamIterator<Tuple4<BigInt, BigInt, BigInt, BigInt>> quadruples, BigInt iterations) {
        AbstractTracer tracer = this.getCurrentTracer();
        Tuple4 firstQuadruple = (Tuple4)quadruples.next();
        tracer.out().printfIndentln("firstQuadruple = %s", new Object[]{firstQuadruple});
        tracer.out().printfIndentln("iterations = %s", new Object[]{iterations});
        Option hit = quadruples.takeWhile((Function1)new Serializable(this, iterations){
            public static final long serialVersionUID = 0L;
            private final BigInt iterations$1;

            public final boolean apply(Tuple4<BigInt, BigInt, BigInt, BigInt> quadruple) {
                return ((BigInt)quadruple._1()).$less(this.iterations$1.$minus(BigInt$.MODULE$.int2bigInt(1)));
            }
            {
                this.iterations$1 = iterations$1;
            }
        }).find((Function1)new Serializable(this, firstQuadruple){
            public static final long serialVersionUID = 0L;
            private final Tuple4 firstQuadruple$1;

            public final boolean apply(Tuple4<BigInt, BigInt, BigInt, BigInt> quadruple) {
                return BoxesRunTime.equals((Object)quadruple._2(), (Object)this.firstQuadruple$1._2());
            }
            {
                this.firstQuadruple$1 = firstQuadruple$1;
            }
        });
        return hit.isDefined() ? new Tuple2((Object)((BigInt)firstQuadruple._3()).$minus((BigInt)((Tuple4)hit.get())._3()), (Object)((BigInt)((Tuple4)hit.get())._4()).$minus((BigInt)firstQuadruple._4())) : this.searchForMatch(quadruples, iterations.$times(BigInt$.MODULE$.int2bigInt(2)));
    }

    @Override
    public Option<BigInt> calculate() {
        return (Option)this.withTracer("Option[BigInt]", this, "calculate()", new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PollardRho $outer;

            public final Option<BigInt> apply() {
                AbstractTracer tracer = this.$outer.getCurrentTracer();
                BigInt x0 = package$.MODULE$.BigInt().apply(this.$outer.p().bitLength(), new Random()).$plus(BigInt$.MODULE$.int2bigInt(1)).mod(this.$outer.p());
                Tuple2<BigInt, BigInt> hit = this.$outer.searchForMatch((StreamIterator<Tuple4<BigInt, BigInt, BigInt, BigInt>>)new StreamIterator(this.$outer.quadrupleSequence(x0)), BigInt$.MODULE$.int2bigInt(1));
                tracer.out().printfIndentln("hit = %s", new Object[]{hit});
                Predef$.MODULE$.assert(BoxesRunTime.equalsNumNum((Number)this.$outer.a().modPow((BigInt)hit._1(), this.$outer.p()), (Number)this.$outer.b().modPow((BigInt)hit._2(), this.$outer.p())), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Wrong exponents.";
                    }
                });
                LinearCongruence linearCongruence = new LinearCongruence((Tuple3<BigInt, BigInt, BigInt>)new Tuple3(hit._2(), hit._1(), (Object)this.$outer.order()));
                Predef$.MODULE$.assert(linearCongruence.crossCheck(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Computation of linear congruence failed.";
                    }
                });
                Predef$.MODULE$.assert(!((SetLike)linearCongruence.outcome()).isEmpty(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Empty solution set for linear congruence.";
                    }
                });
                return ((IterableLike)linearCongruence.outcome()).find((Function1)new Serializable(this, tracer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$calculate$3 $outer;
                    private final AbstractTracer tracer$1;

                    public final boolean apply(BigInt x) {
                        this.tracer$1.out().printfIndentln("x = %s", new Object[]{x});
                        return BoxesRunTime.equalsNumNum((Number)this.$outer.de$christofreichardt$scala$krypto$algorithms$PollardRho$$anonfun$$$outer().a().modPow(x, this.$outer.de$christofreichardt$scala$krypto$algorithms$PollardRho$$anonfun$$$outer().p()), (Number)this.$outer.de$christofreichardt$scala$krypto$algorithms$PollardRho$$anonfun$$$outer().b());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tracer$1 = tracer$1;
                    }
                });
            }

            public /* synthetic */ PollardRho de$christofreichardt$scala$krypto$algorithms$PollardRho$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public PollardRho(DLProblem dlProblem) {
        super(dlProblem);
    }
}

