/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.krypto.algorithms;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.scala.krypto.DLProblem;
import de.christofreichardt.scala.krypto.algorithms.Algorithm;
import de.christofreichardt.scala.krypto.algorithms.ChineseRemainderTheorem;
import de.christofreichardt.scala.krypto.algorithms.DLAlgorithm;
import de.christofreichardt.scala.krypto.algorithms.PohligHellmanAlgo$;
import de.christofreichardt.scala.krypto.algorithms.PrimeFactorization;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u0001\u00154Q!\u0001\u0002\u0002\u00025\u0011\u0011\u0003U8iY&<\u0007*\u001a7m[\u0006t\u0017\t\\4p\u0015\t\u0019A!\u0001\u0006bY\u001e|'/\u001b;i[NT!!\u0002\u0004\u0002\r-\u0014\u0018\u0010\u001d;p\u0015\t9\u0001\"A\u0003tG\u0006d\u0017M\u0003\u0002\n\u0015\u0005\t2\r\u001b:jgR|gM]3jG\"\f'\u000f\u001a;\u000b\u0003-\t!\u0001Z3\u0004\u0001U\u0011abH\n\u0003\u0001=\u0001\"\u0001E\t\u000e\u0003\tI!A\u0005\u0002\u0003\u0017\u0011c\u0015\t\\4pe&$\b.\u001c\u0005\t)\u0001\u0011\t\u0011)A\u0005+\u0005IA\r\u001c)s_\ndW-\u001c\t\u0003-]i\u0011\u0001B\u0005\u00031\u0011\u0011\u0011\u0002\u0012'Qe>\u0014G.Z7\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\tar\u0005E\u0002\u0011\u0001u\u0001\"AH\u0010\r\u0001\u0011)\u0001\u0005\u0001b\u0001C\t\tA+\u0005\u0002#\u001fA\u00111%J\u0007\u0002I)\tq!\u0003\u0002'I\t9aj\u001c;iS:<\u0007\"\u0002\u000b\u001a\u0001\u0004)\u0002\u0002C\u0015\u0001\u0011\u000b\u0007I\u0011\u0001\u0016\u0002\u0019A\u0014\u0018.\\3GC\u000e$xN]:\u0016\u0003-\u00022\u0001\f\u001b8\u001d\ti#G\u0004\u0002/c5\tqF\u0003\u00021\u0019\u00051AH]8pizJ\u0011aB\u0005\u0003g\u0011\nq\u0001]1dW\u0006<W-\u0003\u00026m\t!A*[:u\u0015\t\u0019D\u0005\u0005\u0003$qij\u0014BA\u001d%\u0005\u0019!V\u000f\u001d7feA\u0011AfO\u0005\u0003yY\u0012aAQ5h\u0013:$\bCA\u0012?\u0013\tyDEA\u0002J]RD\u0001\"\u0011\u0001\t\u0002\u0003\u0006KaK\u0001\u000eaJLW.\u001a$bGR|'o\u001d\u0011\t\u0011\r\u0003\u0001R1A\u0005\u0002\u0011\u000b\u0011\"Z9vCRLwN\\:\u0016\u0003\u0015\u00032\u0001\f\u001bG!\u0011\u0019\u0003h\u0012%\u0011\u00071\"$\b\u0005\u0003$qiR\u0004\u0002\u0003&\u0001\u0011\u0003\u0005\u000b\u0015B#\u0002\u0015\u0015\fX/\u0019;j_:\u001c\b\u0005\u0003\u0005M\u0001!\u0015\r\u0011\"\u0001N\u0003Ia\u0017n\u001d;PM\u000e|WM\u001a4jG&,g\u000e^:\u0016\u00039\u00032a\u0014+H\u001b\u0005\u0001&BA)S\u0003%IW.\\;uC\ndWM\u0003\u0002TI\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U\u0002\u0006\u0002\u0003,\u0001\u0011\u0003\u0005\u000b\u0015\u0002(\u0002'1L7\u000f^(gG>,gMZ5dS\u0016tGo\u001d\u0011\t\u000ba\u0003a\u0011A-\u0002/\r\u0014X-\u0019;f\u00032<wN]5uQ6Len\u001d;b]\u000e,GCA\u000f[\u0011\u0015!r\u000b1\u0001\u0016\u0011\u0015a\u0006\u0001\"\u0001+\u000391\u0017m\u0019;pe&TXm\u0014:eKJDQA\u0018\u0001\u0005\u0002\u0011\u000baBY;jY\u0012,\u0015/^1uS>t7\u000fC\u0003a\u0001\u0011\u0005\u0011-A\u0005dC2\u001cW\u000f\\1uKR\t!\rE\u0002$GjJ!\u0001\u001a\u0013\u0003\r=\u0003H/[8o\u0001")
public abstract class PohligHellmanAlgo<T extends DLAlgorithm>
extends DLAlgorithm {
    private List<Tuple2<BigInt, Object>> primeFactors;
    private List<Tuple2<List<BigInt>, Tuple2<BigInt, BigInt>>> equations;
    private List<List<BigInt>> listOfcoefficients;
    private volatile byte bitmap$0;

    private List primeFactors$lzycompute() {
        PohligHellmanAlgo pohligHellmanAlgo = this;
        synchronized (pohligHellmanAlgo) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.primeFactors = this.factorizeOrder();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.primeFactors;
        }
    }

    private List equations$lzycompute() {
        PohligHellmanAlgo pohligHellmanAlgo = this;
        synchronized (pohligHellmanAlgo) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.equations = this.buildEquations();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.equations;
        }
    }

    private List listOfcoefficients$lzycompute() {
        PohligHellmanAlgo pohligHellmanAlgo = this;
        synchronized (pohligHellmanAlgo) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.listOfcoefficients = (List)this.equations().unzip((Function1)Predef$.MODULE$.conforms())._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.listOfcoefficients;
        }
    }

    public List<Tuple2<BigInt, Object>> primeFactors() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.primeFactors$lzycompute() : this.primeFactors;
    }

    public List<Tuple2<List<BigInt>, Tuple2<BigInt, BigInt>>> equations() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.equations$lzycompute() : this.equations;
    }

    public List<List<BigInt>> listOfcoefficients() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.listOfcoefficients$lzycompute() : this.listOfcoefficients;
    }

    public abstract T createAlgorithmInstance(DLProblem var1);

    public List<Tuple2<BigInt, Object>> factorizeOrder() {
        return (List)this.withTracer("List[Tuple2[BigInt,Int]]", this, "factorizeOrder()", new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PohligHellmanAlgo $outer;

            public final List<Tuple2<BigInt, Object>> apply() {
                AbstractTracer tracer = this.$outer.getCurrentTracer();
                PrimeFactorization primeFactorization = new PrimeFactorization(this.$outer.order());
                Predef$.MODULE$.assert(primeFactorization.crossCheck() || primeFactorization.productCheck(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$factorizeOrder$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Prime factorization of ").append((Object)this.$outer.de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$anonfun$$$outer().order()).append((Object)" failed.").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                tracer.out().printfIndentln("primeFactorization(%s).outcome = %s", new Object[]{this.$outer.order(), primeFactorization.outcome()});
                return ((List)primeFactorization.outcome()).reverse();
            }

            public /* synthetic */ PohligHellmanAlgo de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public List<Tuple2<List<BigInt>, Tuple2<BigInt, BigInt>>> buildEquations() {
        return (List)this.withTracer("List[Tuple2[List[BigInt],Tuple2[BigInt,BigInt]]]", this, "buildEquations()", new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PohligHellmanAlgo $outer;

            public final List<Tuple2<List<BigInt>, Tuple2<BigInt, BigInt>>> apply() {
                return (List)((TraversableLike)this.$outer.primeFactors().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildEquations$1 $outer;

                    public final Tuple4<Tuple2<BigInt, Object>, BigInt, Tuple2<List<BigInt>, BigInt>, BigInt> apply(Tuple2<BigInt, Object> factor) {
                        BigInt c = this.$outer.de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$anonfun$$$outer().a().modPow(this.$outer.de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$anonfun$$$outer().order().$div((BigInt)factor._1()), this.$outer.de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$anonfun$$$outer().p());
                        Tuple2 coefficients = this.$outer.de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$anonfun$$$outer().de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$computeCoefficients$1((BigInt)factor._1(), factor._2$mcI$sp() - 1, c);
                        BigInt modulus = ((BigInt)factor._1()).pow(factor._2$mcI$sp());
                        return new Tuple4(factor, (Object)c, (Object)coefficients, (Object)modulus);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<List<BigInt>, Tuple2<BigInt, BigInt>> apply(Tuple4<Tuple2<BigInt, Object>, BigInt, Tuple2<List<BigInt>, BigInt>, BigInt> x$2) {
                        Tuple4<Tuple2<BigInt, Object>, BigInt, Tuple2<List<BigInt>, BigInt>, BigInt> tuple4 = x$2;
                        if (tuple4 != null) {
                            Tuple2 coefficients = (Tuple2)tuple4._3();
                            BigInt modulus = (BigInt)tuple4._4();
                            Tuple2 tuple2 = new Tuple2(coefficients._1(), (Object)new Tuple2(coefficients._2(), (Object)modulus));
                            return tuple2;
                        }
                        throw new MatchError(tuple4);
                    }
                }, List$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ PohligHellmanAlgo de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Option<BigInt> calculate() {
        return (Option)this.withTracer("Option[BigInt]", this, "calculate()", new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PohligHellmanAlgo $outer;

            public final Option<BigInt> apply() {
                Some some;
                AbstractTracer tracer = this.$outer.getCurrentTracer();
                try {
                    if (this.$outer.equations().length() > 1) {
                        ChineseRemainderTheorem chineseRemainderTheorem = new ChineseRemainderTheorem((List<Tuple2<BigInt, BigInt>>)((List)this.$outer.equations().unzip((Function1)Predef$.MODULE$.conforms())._2()));
                        some = new Some(chineseRemainderTheorem.outcome());
                    } else {
                        some = new Some(((Tuple2)((IterableLike)this.$outer.equations().unzip((Function1)Predef$.MODULE$.conforms())._2()).head())._1());
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    tracer.logException(LogLevel.ERROR, (Throwable)arithmeticException, this.$outer.getClass(), "calculate()");
                    some = None$.MODULE$;
                }
                return some;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final Tuple2 de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$computeCoefficients$1(BigInt prime, int index, BigInt c) {
        return (Tuple2)this.withTracer("Tuple2[List[BigInt],BigInt]", this, "computeCoefficients(prime: BigInt, index: Int, c: BigInt)", new Serializable(this, prime, index, c){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PohligHellmanAlgo $outer;
            private final BigInt prime$1;
            private final int index$1;
            private final BigInt c$1;

            public final Tuple2<List<BigInt>, BigInt> apply() {
                BigInt B;
                block5: {
                    Tuple2 tuple2;
                    block4: {
                        AbstractTracer tracer;
                        block2: {
                            BigInt B2;
                            block3: {
                                tracer = this.$outer.getCurrentTracer();
                                tracer.out().printfIndentln("prime = %s", new Object[]{this.prime$1});
                                tracer.out().printfIndentln("index = %d", new Object[]{Predef$.MODULE$.int2Integer(this.index$1)});
                                tracer.out().printfIndentln("c = %s", new Object[]{this.c$1});
                                if (this.index$1 != 0) break block2;
                                B2 = this.$outer.b().modPow(this.$outer.order().$div(this.prime$1), this.$outer.p());
                                T subordinateDLAlgorithm = this.$outer.createAlgorithmInstance(new DLProblem((Tuple4<BigInt, BigInt, BigInt, BigInt>)new Tuple4((Object)this.c$1, (Object)B2, (Object)this.$outer.p(), (Object)this.prime$1)));
                                tracer.out().printfIndentln("subordinateDLAlgorithm = %s", new Object[]{subordinateDLAlgorithm});
                                if (!((Option)((Algorithm)subordinateDLAlgorithm).outcome()).isDefined()) break block3;
                                tuple2 = new Tuple2((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BigInt[]{(BigInt)((Option)((Algorithm)subordinateDLAlgorithm).outcome()).get()})), ((Option)((Algorithm)subordinateDLAlgorithm).outcome()).get());
                                break block4;
                            }
                            throw new ArithmeticException(new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.c$1), "^x = ")).append((Object)B2).append((Object)" [mod ").append((Object)this.$outer.p()).append((Object)"] has no solution.").toString());
                        }
                        Tuple2 previousCoefficients = this.$outer.de$christofreichardt$scala$krypto$algorithms$PohligHellmanAlgo$$computeCoefficients$1(this.prime$1, this.index$1 - 1, this.c$1);
                        BigInt exp = this.$outer.order().$div(this.prime$1.pow(this.index$1 + 1));
                        BigInt inverseA = this.$outer.a().modPow((BigInt)previousCoefficients._2(), this.$outer.p()).modInverse(this.$outer.p());
                        B = this.$outer.b().$times(inverseA).modPow(exp, this.$outer.p());
                        T subordinateDLAlgorithm = this.$outer.createAlgorithmInstance(new DLProblem((Tuple4<BigInt, BigInt, BigInt, BigInt>)new Tuple4((Object)this.c$1, (Object)B, (Object)this.$outer.p(), (Object)this.prime$1)));
                        tracer.out().printfIndentln("subordinateDLAlgorithm = %s", new Object[]{subordinateDLAlgorithm});
                        if (!((Option)((Algorithm)subordinateDLAlgorithm).outcome()).isDefined()) break block5;
                        BigInt bigInt = (BigInt)((Option)((Algorithm)subordinateDLAlgorithm).outcome()).get();
                        Tuple2 tuple22 = new Tuple2((Object)((List)previousCoefficients._1()).$colon$colon((Object)bigInt), (Object)this.prime$1.pow(this.index$1).$times((BigInt)((Option)((Algorithm)subordinateDLAlgorithm).outcome()).get()).$plus((BigInt)previousCoefficients._2()));
                        tuple2 = tuple22;
                    }
                    return tuple2;
                }
                throw new ArithmeticException(new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.c$1), "^x = ")).append((Object)B).append((Object)" [mod ").append((Object)this.$outer.p()).append((Object)"] has no solution.").toString());
            }
            {
                void var4_4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.prime$1 = prime$1;
                this.index$1 = index$1;
                this.c$1 = var4_4;
            }
        });
    }

    public PohligHellmanAlgo(DLProblem dlProblem) {
        super(dlProblem);
    }
}

