/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.krypto.algorithms;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.scala.krypto.Constants$;
import de.christofreichardt.scala.krypto.DLProblem;
import de.christofreichardt.scala.krypto.algorithms.Algorithm;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u0001e3Q!\u0001\u0002\u0002\u00025\u00111\u0002\u0012'BY\u001e|'/\u001b;i[*\u00111\u0001B\u0001\u000bC2<wN]5uQ6\u001c(BA\u0003\u0007\u0003\u0019Y'/\u001f9u_*\u0011q\u0001C\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u0013)\t\u0011c\u00195sSN$xN\u001a:fS\u000eD\u0017M\u001d3u\u0015\u0005Y\u0011A\u00013f\u0007\u0001\u0019\"\u0001\u0001\b\u0011\t=\u0001\"CF\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\n\u00032<wN]5uQ6\u0004\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u0013\u0011c\u0005K]8cY\u0016l\u0007cA\f\u001a75\t\u0001DC\u0001\b\u0013\tQ\u0002D\u0001\u0004PaRLwN\u001c\t\u00039\u0011r!!\b\u0012\u000f\u0005y\tS\"A\u0010\u000b\u0005\u0001b\u0011A\u0002\u001fs_>$h(C\u0001\b\u0013\t\u0019\u0003$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00152#A\u0002\"jO&sGO\u0003\u0002$1!A\u0001\u0006\u0001B\u0001B\u0003%!#A\u0005eYB\u0013xN\u00197f[\")!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"\"\u0001L\u0017\u0011\u0005=\u0001\u0001\"\u0002\u0015*\u0001\u0004\u0011\u0002bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\u0002CV\t1\u0004\u0003\u00043\u0001\u0001\u0006IaG\u0001\u0003C\u0002Bq\u0001\u000e\u0001C\u0002\u0013\u0005\u0001'A\u0001c\u0011\u00191\u0004\u0001)A\u00057\u0005\u0011!\r\t\u0005\bq\u0001\u0011\r\u0011\"\u00011\u0003\u0005\u0001\bB\u0002\u001e\u0001A\u0003%1$\u0001\u0002qA!9A\b\u0001b\u0001\n\u0003\u0001\u0014!B8sI\u0016\u0014\bB\u0002 \u0001A\u0003%1$\u0001\u0004pe\u0012,'\u000f\t\u0005\u0006\u0001\u0002!\t%Q\u0001\ti>\u001cFO]5oOR\t!\t\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!A.\u00198h\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\rM#(/\u001b8h\u0011\u0015Y\u0005\u0001\"\u0011M\u0003)\u0019'o\\:t\u0007\",7m\u001b\u000b\u0002\u001bB\u0011qCT\u0005\u0003\u001fb\u0011qAQ8pY\u0016\fg\u000eC\u0003R\u0001\u0011\u0005#+\u0001\thKR\u001cUO\u001d:f]R$&/Y2feR\t1\u000b\u0005\u0002U/6\tQK\u0003\u0002W\u0011\u0005IA-[1h]>\u001c\u0018n]\u0005\u00031V\u0013a\"\u00112tiJ\f7\r\u001e+sC\u000e,'\u000f")
public abstract class DLAlgorithm
extends Algorithm<DLProblem, Option<BigInt>> {
    public final DLProblem de$christofreichardt$scala$krypto$algorithms$DLAlgorithm$$dlProblem;
    private final BigInt a;
    private final BigInt b;
    private final BigInt p;
    private final BigInt order;

    public BigInt a() {
        return this.a;
    }

    public BigInt b() {
        return this.b;
    }

    public BigInt p() {
        return this.p;
    }

    public BigInt order() {
        return this.order;
    }

    public String toString() {
        return new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.a()), "^x = ")).append((Object)this.b()).append((Object)" (mod ").append((Object)this.p()).append((Object)"), ord(").append((Object)this.a()).append((Object)") = ").append((Object)this.order()).toString();
    }

    @Override
    public boolean crossCheck() {
        return BoxesRunTime.unboxToBoolean(this.withTracer("Boolean", this, "crossCheck()", new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DLAlgorithm $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                if (((Option)this.$outer.outcome()).isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Algorithm hasn't found any solution for: ").append((Object)this.$outer).toString());
                }
                return BoxesRunTime.equalsNumNum((Number)this.$outer.a().modPow((BigInt)((Option)this.$outer.outcome()).get(), this.$outer.p()), (Number)this.$outer.b());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        AbstractTracer abstractTracer;
        try {
            abstractTracer = TracerFactory.getInstance().getTracer("TestTracer");
        }
        catch (TracerFactory.Exception exception) {
            abstractTracer = TracerFactory.getInstance().getDefaultTracer();
        }
        return abstractTracer;
    }

    public DLAlgorithm(DLProblem dlProblem) {
        this.de$christofreichardt$scala$krypto$algorithms$DLAlgorithm$$dlProblem = dlProblem;
        super(dlProblem);
        this.a = dlProblem.a();
        this.b = dlProblem.b();
        this.p = dlProblem.p();
        this.order = dlProblem.order();
        Predef$.MODULE$.require(this.a().$greater(BigInt$.MODULE$.int2bigInt(0)) && this.b().$greater(BigInt$.MODULE$.int2bigInt(0)) && this.p().$greater(BigInt$.MODULE$.int2bigInt(0)) && this.order().$greater(BigInt$.MODULE$.int2bigInt(0)), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DLAlgorithm $outer;

            public final DLProblem apply() {
                return this.$outer.de$christofreichardt$scala$krypto$algorithms$DLAlgorithm$$dlProblem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(this.p().isProbablePrime(Constants$.MODULE$.certainty()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Provide a prime modulus.";
            }
        });
        Predef$.MODULE$.require(BoxesRunTime.equalsNumNum((Number)this.a().modPow(this.order(), this.p()), (Number)package$.MODULE$.BigInt().apply(1)), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Incorrect order";
            }
        });
        Predef$.MODULE$.require(this.a().$less(this.p()) && this.b().$less(this.p()) && this.order().$less(this.p()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DLAlgorithm $outer;

            public final DLProblem apply() {
                return this.$outer.de$christofreichardt$scala$krypto$algorithms$DLAlgorithm$$dlProblem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

