/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;

/**
 *
 * @author Christof Reichardt
 */
public class OfflineProvider implements PriceExtractorStrategy, Traceable{

  @Override
  public AbstractSecurityPrice extractPrice(String id) throws SecurityPriceServiceException {
    AbstractTracer tracer = getCurrentTracer();
    tracer.entry("AbstractSecurityPrice", this, "extractPrice(String id)");
    
    try {
      tracer.out().printfIndentln("id = %s", id);
      
      ObjectFactory objectFactory = new ObjectFactory();
      Security security = objectFactory.createSecurity();
      security.setISIN("xxxxxxxxxxxx");
      security.setWKN("xxxxxx");
      security.setName("Offline Test");
      UnknownPrice unknownPrice = objectFactory.createUnknownPrice();
//      UnknownPrice unknownPrice = new MyUnknownPrice();
      unknownPrice.setSecurity(security);
      
      return unknownPrice;
    }
    finally {
      tracer.wayout();
    }
  }

  @Override
  public AbstractTracer getCurrentTracer() {
    return TracerFactory.getInstance().getCurrentQueueTracer();
  }

}
