
package de.christofreichardt.jaxws.securitypriceservice;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java-Klasse fr Exercise.
 * 
 * <p>Das folgende Schemafragment gibt den erwarteten Content an, der in dieser Klasse enthalten ist.
 * <p>
 * <pre>
 * &lt;simpleType name="Exercise">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="european"/>
 *     &lt;enumeration value="american"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "Exercise")
@XmlEnum
public enum Exercise {

    @XmlEnumValue("european")
    EUROPEAN("european"),
    @XmlEnumValue("american")
    AMERICAN("american");
    private final String value;

    Exercise(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static Exercise fromValue(String v) {
        for (Exercise c: Exercise.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
