/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.jaxws.securitypriceservice.PriceRequestUnit;
import de.christofreichardt.jaxws.securitypriceservice.SecurityPriceService;
import de.christofreichardt.junit.MyTestComputer;
import de.christofreichardt.junit.MyTestSuite;
import de.christofreichardt.junit.TraceTestListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.wildfly.WildFly10xInstalledLocalContainer;
import org.codehaus.cargo.container.wildfly.WildFly8xExistingLocalConfiguration;
import org.junit.runner.Computer;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runners.Suite;

@RunWith(value=MyTestSuite.class)
@Suite.SuiteClasses(value={PriceRequestUnit.class})
public class IntegrationTests
implements Traceable {
    private InstalledLocalContainer installedLocalContainer;
    private final String wildFlyHome;
    private final Properties properties = this.readProperties();
    private final String wsdlLocation;
    private final String proxyHost;
    private final String proxyPort;

    private IntegrationTests() {
        this.wildFlyHome = this.properties.getProperty("de.christofreichardt.jaxws.securitypriceservice.wildfly_home");
        this.wsdlLocation = this.properties.getProperty("de.christofreichardt.jaxws.securitypriceservice.wsdl_location");
        this.proxyHost = this.properties.getProperty("de.christofreichardt.jaxws.securitypriceservice.http.proxyHost", null);
        this.proxyPort = this.properties.getProperty("de.christofreichardt.jaxws.securitypriceservice.http.proxyPort", "80");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Properties", (Object)this, "readProperties()");
        try {
            Properties properties = new Properties();
            File propertyFile = new File("." + File.separator + "integrationtest.properties");
            try (FileInputStream inputStream = new FileInputStream(propertyFile);){
                properties.load(inputStream);
            }
            catch (IOException ex) {
                tracer.logException(LogLevel.ERROR, (Throwable)ex, this.getClass(), "readProperties()");
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWildFly() throws MalformedURLException, InterruptedException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("InstalledLocalContainer", (Object)this, "startWildFly()");
        try {
            tracer.out().printfIndentln("IntegrationTests.getInstance().getWildFlyHome() = %s", new Object[]{this.wildFlyHome});
            WildFly8xExistingLocalConfiguration localConfiguration = new WildFly8xExistingLocalConfiguration(this.wildFlyHome + "/standalone");
            localConfiguration.setProperty("cargo.jboss.configuration", "standalone-full");
            WAR deployable = new WAR("../SecurityPriceService-server/target/SecurityPriceService-server-0.0.1-SNAPSHOT.war");
            localConfiguration.addDeployable((Deployable)deployable);
            this.installedLocalContainer = new WildFly10xInstalledLocalContainer((LocalConfiguration)localConfiguration);
            this.installedLocalContainer.setHome(this.wildFlyHome);
            this.installedLocalContainer.setTimeout(60000L);
            HashMap<String, String> systemProperties = new HashMap<String, String>();
            systemProperties.put("java.net.preferIPv4Stack", "true");
            if (this.proxyHost != null) {
                systemProperties.put("http.proxyHost", this.proxyHost);
                systemProperties.put("http.proxyPort", this.proxyPort);
            }
            this.installedLocalContainer.setSystemProperties(systemProperties);
            this.installedLocalContainer.start();
            URL url = new URL(this.wsdlLocation);
            QName qName = new QName("http://securitypriceservice.jaxws.christofreichardt.de/", "SecurityPriceService");
            int counter = 0;
            int MAX_TRIALS = 5;
            int DELAY = 2500;
            while (true) {
                try {
                    SecurityPriceService securityPriceService = new SecurityPriceService(url, qName);
                }
                catch (WebServiceException ex) {
                    tracer.logMessage(LogLevel.INFO, "[" + counter + "] Pinging service ...", PriceRequestUnit.class, "void startWildfly()");
                    if (counter == 5) {
                        tracer.logMessage(LogLevel.INFO, "Webservice isn't available after 5. Giving up.", PriceRequestUnit.class, "void startWildfly()");
                        throw ex;
                    }
                    Thread.sleep(2500L);
                    ++counter;
                    continue;
                }
                break;
            }
        }
        finally {
            tracer.wayout();
        }
    }

    private void stopWildFly() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "stopWildFly()");
        try {
            this.installedLocalContainer.stop();
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "run()");
        try {
            JUnitCore jUnitCore = new JUnitCore();
            jUnitCore.addListener((RunListener)new TraceTestListener());
            Result result = jUnitCore.run((Computer)new MyTestComputer(this.properties), new Class[]{PriceRequestUnit.class});
            this.traceResults(result);
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceResults(Result result) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "traceResults(Result result)");
        try {
            tracer.out().printfIndentln("result.getRunCount() = %d", new Object[]{result.getRunCount()});
            tracer.out().printfIndentln("result.getFailureCount() = %d", new Object[]{result.getFailureCount()});
            tracer.out().printfIndentln("result.getRunTime() = %dms", new Object[]{result.getRunTime()});
            System.out.printf("%nresult.getRunCount() = %d%n", result.getRunCount());
            System.out.printf("result.getFailureCount() = %d%n", result.getFailureCount());
            System.out.printf("result.getRunTime() = %dms%n%n", result.getRunTime());
            if (result.wasSuccessful()) {
                tracer.logMessage(LogLevel.INFO, "Test run has been successful.", this.getClass(), "traceResults(Result result)");
            } else {
                tracer.logMessage(LogLevel.WARNING, "Test run has failed.", this.getClass(), "traceResults(Result result)");
            }
            for (Failure failure : result.getFailures()) {
                tracer.out().printIndentln("+-----------------------------------------------------------------------------------------------------+");
                tracer.out().printfIndentln("%s[failure.getException() = %s]", new Object[]{failure.getDescription().getDisplayName(), failure.getException()});
                Throwable throwable = failure.getException();
                do {
                    StackTraceElement[] stackTraceElements;
                    for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
                        tracer.out().printfIndentln("  at %s.%s(%s:%d)", new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()});
                    }
                    if ((throwable = throwable.getCause()) == null) continue;
                    tracer.out().printfIndentln("caused by = %s: %s", new Object[]{throwable.getClass().getName(), throwable.getMessage()});
                } while (throwable != null);
            }
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws TracerFactory.Exception {
        TracerFactory.getInstance().reset();
        InputStream resourceAsStream = IntegrationTests.class.getClassLoader().getResourceAsStream("de/christofreichardt/jaxws/securitypriceservice/trace-config.xml");
        if (resourceAsStream != null) {
            TracerFactory.getInstance().readConfiguration(resourceAsStream);
        }
        TracerFactory.getInstance().openPoolTracer();
        try {
            AbstractTracer tracer = TracerFactory.getInstance().getCurrentPoolTracer();
            tracer.initCurrentTracingContext();
            tracer.entry("void", IntegrationTests.class, "main(String[] args)");
            try {
                for (int i = 0; i < args.length; ++i) {
                    tracer.out().printfIndentln("arg[%d] = %s", new Object[]{i, args[i]});
                }
                ArrayList<String> propertyNames = new ArrayList<String>(System.getProperties().stringPropertyNames());
                Collections.sort(propertyNames);
                for (String propertyName : propertyNames) {
                    tracer.out().printfIndentln("%s = %s", new Object[]{propertyName, System.getProperties().getProperty(propertyName)});
                }
                IntegrationTests integrationTests = new IntegrationTests();
                try {
                    integrationTests.startWildFly();
                    integrationTests.run();
                }
                catch (InterruptedException | MalformedURLException ex) {
                    tracer.logException(LogLevel.ERROR, (Throwable)ex, IntegrationTests.class, "void main(String[] args)");
                }
                finally {
                    integrationTests.stopWildFly();
                }
            }
            finally {
                tracer.wayout();
            }
        }
        finally {
            TracerFactory.getInstance().closePoolTracer();
        }
    }
}

