/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.jaxws.securitypriceservice.AbstractSecurityPrice;
import de.christofreichardt.jaxws.securitypriceservice.SecurityPriceService;
import de.christofreichardt.jaxws.securitypriceservice.SecurityPriceServiceException;
import de.christofreichardt.jaxws.securitypriceservice.SecurityPriceServicePortType;
import de.christofreichardt.jaxws.securitypriceservice.SecurityPriceServiceRequest;
import de.christofreichardt.jaxws.securitypriceservice.SecurityPriceServiceResponse;
import de.christofreichardt.jaxws.securitypriceservice.SignatureHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;

public class App
implements Traceable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void call(SecurityPriceServiceRequest securityPriceServiceRequest) throws MalformedURLException, SecurityPriceServiceException, GeneralSecurityException, IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "call()");
        try {
            Class<?>[] interfaces;
            URL url = new URL("http://127.0.1.1:8080/SecurityPriceService-server-0.0.1-SNAPSHOT/securitypriceservice?wsdl");
            QName qName = new QName("http://securitypriceservice.jaxws.christofreichardt.de/", "SecurityPriceService");
            SecurityPriceService securityPriceService = new SecurityPriceService(url, qName);
            SecurityPriceServicePortType securityPriceServicePort = (SecurityPriceServicePortType)securityPriceService.getPort(SecurityPriceServicePortType.class);
            for (Class<?> interfaze : interfaces = securityPriceServicePort.getClass().getInterfaces()) {
                tracer.out().printfIndentln("interfaze.getName() = %s", new Object[]{interfaze.getName()});
            }
            BindingProvider bindingProvider = (BindingProvider)securityPriceServicePort;
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:7070/SecurityPriceService-server-0.0.1-SNAPSHOT/securitypriceservice");
            List handlerChain = bindingProvider.getBinding().getHandlerChain();
            handlerChain.add(new SignatureHandler());
            bindingProvider.getBinding().setHandlerChain(handlerChain);
            SecurityPriceServiceResponse securityPriceServiceResponse = securityPriceServicePort.findPrice(securityPriceServiceRequest);
            tracer.out().printfIndentln("securityPriceServiceResponse.getTimestamp() = %s", new Object[]{securityPriceServiceResponse.getTimestamp()});
            List securityPrices = securityPriceServiceResponse.getSharePriceOrIndexPriceOrOptionPrice();
            for (AbstractSecurityPrice securityPrice : securityPrices) {
                tracer.out().printfIndentln("%s", new Object[]{securityPrice});
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityPriceServiceRequest readRequest(File requestFile) throws JAXBException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("SecurityPriceServiceRequest", (Object)this, "readRequest(File requestFile)");
        try {
            StreamSource streamSource = new StreamSource(requestFile);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SecurityPriceServiceRequest.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement jaxbServiceRequest = unmarshaller.unmarshal((Source)streamSource, SecurityPriceServiceRequest.class);
            SecurityPriceServiceRequest securityPriceServiceRequest = (SecurityPriceServiceRequest)jaxbServiceRequest.getValue();
            return securityPriceServiceRequest;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws TracerFactory.Exception, JAXBException {
        TracerFactory.getInstance().reset();
        InputStream resourceAsStream = App.class.getClassLoader().getResourceAsStream("de/christofreichardt/jaxws/securitypriceservice/trace-config.xml");
        if (resourceAsStream != null) {
            TracerFactory.getInstance().readConfiguration(resourceAsStream);
        }
        TracerFactory.getInstance().openPoolTracer();
        try {
            AbstractTracer tracer = TracerFactory.getInstance().getCurrentPoolTracer();
            tracer.initCurrentTracingContext();
            tracer.entry("void", App.class, "main(String[] args)");
            try {
                for (int i = 0; i < args.length; ++i) {
                    tracer.out().printfIndentln("arg[%d] = %s", new Object[]{i, args[i]});
                }
                ArrayList<String> propertyNames = new ArrayList<String>(System.getProperties().stringPropertyNames());
                Collections.sort(propertyNames);
                for (String propertyName : propertyNames) {
                    tracer.out().printfIndentln("%s = %s", new Object[]{propertyName, System.getProperties().getProperty(propertyName)});
                }
                try {
                    App app = new App();
                    File requestFile = args.length == 0 ? new File("." + File.separator + "xml" + File.separator + "request-1.xml") : new File("." + File.separator + "xml" + File.separator + args[0] + ".xml");
                    SecurityPriceServiceRequest serviceRequest = app.readRequest(requestFile);
                    app.call(serviceRequest);
                }
                catch (SecurityPriceServiceException | IOException | GeneralSecurityException | SOAPFaultException ex) {
                    tracer.logException(LogLevel.ERROR, ex, App.class, "main(String[] args)");
                }
            }
            finally {
                tracer.wayout();
            }
        }
        finally {
            TracerFactory.getInstance().closePoolTracer();
        }
    }
}

