/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.websphere;

import java.util.Random;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.webapp.EjbRef;
import org.codehaus.cargo.module.webapp.VendorWebAppDescriptor;
import org.codehaus.cargo.module.webapp.websphere.IbmWebBndXmiType;
import org.jdom.Element;
import org.jdom.Namespace;

public class IbmWebBndXmi
extends AbstractDescriptor
implements VendorWebAppDescriptor {
    private static final String FILE_NAME = "ibm-web-bnd.xmi";
    private Random random = new Random();

    public IbmWebBndXmi(Element rootElement, DescriptorType type) {
        super(rootElement, type);
    }

    @Override
    public String getFileName() {
        return FILE_NAME;
    }

    @Override
    public void addEjbReference(EjbRef ref) {
        Element ejbRefBindingsElement = new Element("ejbRefBindings");
        String id = "EjbRefBinding_" + this.random.nextLong();
        Namespace namespace = Namespace.getNamespace("xmi", "http://www.omg.org/XMI");
        ejbRefBindingsElement.setAttribute("id", id, namespace);
        ejbRefBindingsElement.setAttribute("jndiName", ref.getJndiName());
        Element bindingEjbRef = new Element("bindingEjbRef");
        bindingEjbRef.setAttribute("href", "WEB-INF/web.xml#" + ref.getName().replace('/', '_'));
        ejbRefBindingsElement.getContent().add(bindingEjbRef);
        this.addElement(new DescriptorTag(IbmWebBndXmiType.getInstance(), "ejbRefBindings", true), ejbRefBindingsElement, this.getRootElement());
    }
}

