/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

public class DefaultContainerFactory
extends AbstractIntrospectionGenericHintFactory<Container>
implements ContainerFactory {
    public DefaultContainerFactory() {
        this(null);
    }

    public DefaultContainerFactory(ClassLoader classLoader) {
        AbstractFactoryRegistry.register(classLoader, this);
    }

    @Override
    public boolean isContainerRegistered(String containerId, ContainerType containerType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()));
    }

    @Override
    public void registerContainer(String containerId, ContainerType containerType, Class<? extends Container> containerClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), containerClass);
    }

    public void registerContainer(String containerId, ContainerType containerType, String containerClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), containerClassName);
    }

    @Override
    public Class<? extends Container> getContainerClass(String containerId, ContainerType containerType) {
        return this.getMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()));
    }

    @Override
    public Container createContainer(String containerId, ContainerType containerType, Configuration configuration) {
        ContainerFactoryParameters parameters = new ContainerFactoryParameters();
        parameters.configuration = configuration;
        return (Container)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), parameters, "container");
    }

    @Override
    protected Constructor<? extends Container> getConstructor(Class<? extends Container> containerClass, String containerType, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor<? extends Container> constructor;
        ContainerType type = ContainerType.toType(containerType);
        if (type.isLocal()) {
            constructor = containerClass.getConstructor(LocalConfiguration.class);
        } else if (type.isRemote()) {
            constructor = containerClass.getConstructor(RuntimeConfiguration.class);
        } else {
            throw new ContainerException("Unknown container type [" + type.getType() + "]");
        }
        return constructor;
    }

    @Override
    protected Container createInstance(Constructor<? extends Container> constructor, String containerType, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Configuration configuration = ((ContainerFactoryParameters)parameters).configuration;
        try {
            return constructor.newInstance(configuration);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t.getMessage() + ", configuration " + configuration.getClass(), t);
        }
    }

    @Override
    public Map<String, Set<ContainerType>> getContainerIds() {
        HashMap<String, Set<ContainerType>> containerIds = new HashMap<String, Set<ContainerType>>();
        for (Map.Entry mapping : this.getMappings().entrySet()) {
            Set<ContainerType> hints;
            RegistrationKey key = mapping.getKey();
            SimpleContainerIdentity identity = (SimpleContainerIdentity)key.getContainerIdentity();
            if (containerIds.containsKey(identity.getId())) {
                hints = (Set)containerIds.get(identity.getId());
                hints.add(ContainerType.toType(key.getHint()));
                continue;
            }
            hints = new HashSet<ContainerType>();
            hints.add(ContainerType.toType(key.getHint()));
            containerIds.put(identity.getId(), hints);
        }
        return containerIds;
    }

    private static class ContainerFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public Configuration configuration;

        private ContainerFactoryParameters() {
        }
    }
}

