/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal.util;

import java.io.IOException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.JarUtils;

public final class WildFlyModuleUtils {
    private WildFlyModuleUtils() {
    }

    public static boolean isModuleDeployed(InstalledLocalContainer container, String jarFile) {
        FileHandler fileHandler = container.getFileHandler();
        String moduleArtifactName = WildFlyModuleUtils.getModuleArtifactName(jarFile, fileHandler);
        String folder = container.getHome() + "/modules/org/codehaus/cargo/classpath/" + moduleArtifactName + "/main";
        return fileHandler.exists(folder);
    }

    public static String getModuleName(InstalledLocalContainer container, String jarFile) {
        FileHandler fileHandler = container.getFileHandler();
        String moduleArtifactName = WildFlyModuleUtils.getModuleArtifactName(jarFile, fileHandler);
        return "org.codehaus.cargo.classpath." + moduleArtifactName;
    }

    private static String getModuleArtifactName(String jarFile, FileHandler fileHandler) {
        String moduleName = fileHandler.getName(jarFile);
        moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
        moduleName = moduleName.replace('.', '-');
        return moduleName;
    }

    public static String getDataSourceDriverModuleName(InstalledLocalContainer container, DataSource ds) {
        String driverJarFile = null;
        String driverClass = ds.getDriverClass();
        try {
            driverJarFile = WildFlyModuleUtils.findJarFile(container, driverClass);
        }
        catch (IOException e) {
            throw new CargoException("Caught Exception while looking for DataSource driver class module: " + driverClass, e);
        }
        if (driverJarFile == null) {
            throw new CargoException("Datasource driver class " + driverClass + " wasn't found in the classpath");
        }
        return WildFlyModuleUtils.getModuleName(container, driverJarFile);
    }

    private static String findJarFile(InstalledLocalContainer container, String clazz) throws IOException {
        JarUtils jarUtils = new JarUtils();
        String classJarFile = null;
        for (String classpathElement : container.getExtraClasspath()) {
            if (!jarUtils.containsClass(classpathElement, clazz)) continue;
            classJarFile = classpathElement;
        }
        for (String classpathElement : container.getSharedClasspath()) {
            if (!jarUtils.containsClass(classpathElement, clazz)) continue;
            classJarFile = classpathElement;
        }
        return classJarFile;
    }
}

