/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.AbstractWildFlyScriptCommand;

public class XaDataSourceScriptCommand
extends AbstractWildFlyScriptCommand {
    private DataSource ds;

    public XaDataSourceScriptCommand(Configuration configuration, String resourcePath, DataSource dataSource) {
        super(configuration, resourcePath);
        this.ds = dataSource;
    }

    @Override
    protected String getScriptRelativePath() {
        return "resource/datasource-xa.cli";
    }

    @Override
    protected void addConfigurationScriptProperties(Map<String, String> propertiesMap) {
        HashMap<String, String> datasourceProperties = new HashMap<String, String>();
        datasourceProperties.put("name", this.ds.getId());
        datasourceProperties.put("jndi-name", this.getDataSourceJndi(this.ds));
        datasourceProperties.put("driver-name", this.ds.getDriverClass());
        datasourceProperties.put("user-name", this.ds.getUsername());
        datasourceProperties.put("password", this.ds.getPassword());
        char delimiter = ',';
        Map<String, String> conProperties = PropertyUtils.toMap(this.ds.getConnectionProperties());
        String customProperties = PropertyUtils.joinOnDelimiter(conProperties, delimiter);
        datasourceProperties.put("xa-datasource-properties", customProperties);
        String dsProps = this.mapResourceProperties(datasourceProperties);
        propertiesMap.put("cargo.datasource.properties", dsProps);
    }
}

