/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.property.TransactionSupport;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.AbstractWildFlyScriptCommand;

public class DataSourceScriptCommand
extends AbstractWildFlyScriptCommand {
    private DataSource ds;

    public DataSourceScriptCommand(Configuration configuration, String resourcePath, DataSource dataSource) {
        super(configuration, resourcePath);
        this.ds = dataSource;
    }

    @Override
    protected String getScriptRelativePath() {
        return "resource/datasource.cli";
    }

    @Override
    protected void addConfigurationScriptProperties(Map<String, String> propertiesMap) {
        HashMap<String, String> datasourceProperties = new HashMap<String, String>();
        datasourceProperties.put("name", this.ds.getId());
        datasourceProperties.put("jndi-name", this.getDataSourceJndi(this.ds));
        datasourceProperties.put("driver-name", this.ds.getDriverClass());
        datasourceProperties.put("connection-url", this.ds.getUrl());
        datasourceProperties.put("user-name", this.ds.getUsername());
        datasourceProperties.put("password", this.ds.getPassword());
        if (TransactionSupport.NO_TRANSACTION.equals(this.ds.getTransactionSupport())) {
            datasourceProperties.put("jta", "false");
        } else {
            datasourceProperties.put("jta", "true");
        }
        String dsProps = this.mapResourceProperties(datasourceProperties);
        propertiesMap.put("cargo.datasource.properties", dsProps);
    }
}

