/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal.configuration.commands;

import java.util.Map;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.configuration.script.AbstractScriptCommand;

public abstract class AbstractWildFlyScriptCommand
extends AbstractScriptCommand {
    public AbstractWildFlyScriptCommand(Configuration configuration, String resourcePath) {
        super(configuration, resourcePath);
    }

    protected String getResourceJndi(Resource resource) {
        String jndiName = resource.getName();
        return this.sanitizeJndiName(jndiName);
    }

    protected String getDataSourceJndi(DataSource ds) {
        String jndiName = ds.getJndiLocation();
        return this.sanitizeJndiName(jndiName);
    }

    private String sanitizeJndiName(String jndiName) {
        String response = jndiName;
        if (!jndiName.startsWith("java:/")) {
            response = "java:/" + jndiName;
            this.getConfiguration().getLogger().warn("WildFly requires resource JNDI names to start with java:/, hence changing the given JNDI name to: " + response, this.getClass().getName());
        }
        return response;
    }

    protected String mapResourceProperties(Map<String, String> resourceProperties) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> element : resourceProperties.entrySet()) {
            if (element.getValue() == null || element.getValue().isEmpty()) continue;
            sb.append(" --");
            sb.append(element.getKey());
            sb.append("=");
            sb.append(element.getValue());
        }
        return sb.toString();
    }
}

