/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal;

import java.util.Arrays;
import java.util.List;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.script.ScriptCommand;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.container.wildfly.internal.WildFlyConfiguration;
import org.codehaus.cargo.container.wildfly.internal.util.WildFlyModuleUtils;
import org.codehaus.cargo.container.wildfly.internal.util.WildFlyUserUtils;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractWildFlyStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration
implements WildFlyConfiguration {
    public AbstractWildFlyStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.jboss.configuration", "standalone");
        this.setProperty("cargo.jboss.modules.dir", "modules");
        this.setProperty("cargo.jboss.ajp.port", "8009");
        this.setProperty("cargo.jboss.management-http.port", "9990");
    }

    @Override
    protected void doConfigure(LocalContainer c) throws Exception {
        InstalledLocalContainer container = (InstalledLocalContainer)c;
        this.setupConfigurationDir();
        String initialConfiguration = this.getFileHandler().append(container.getHome(), "standalone");
        this.getFileHandler().copyDirectory(initialConfiguration, this.getHome());
        String configurationXmlFile = "configuration/" + this.getPropertyValue("cargo.jboss.configuration") + ".xml";
        String configurationXML = this.getFileHandler().append(this.getHome(), configurationXmlFile);
        if (!this.getFileHandler().exists(configurationXML)) {
            throw new CargoException("Missing configuration XML file: " + configurationXML);
        }
        this.getLogger().info("Configuring JBoss using the [" + this.getPropertyValue("cargo.jboss.configuration") + "] server configuration", this.getClass().getName());
        this.createMgmtUsersProperties();
        this.createApplicationUsersProperties();
        this.createApplicationRolesProperties();
    }

    protected void addModuleScript(String jarFile, InstalledLocalContainer container, List<ScriptCommand> configurationScript) {
        String moduleName = WildFlyModuleUtils.getModuleName(container, jarFile);
        boolean isModuleDeployed = WildFlyModuleUtils.isModuleDeployed(container, jarFile);
        if (isModuleDeployed) {
            this.getLogger().warn("Module " + moduleName + " already exists, skipping it.", this.getClass().getName());
        } else {
            List<String> dependencies = Arrays.asList("javax.api", "javax.transaction.api");
            configurationScript.add(this.getConfigurationFactory().addModuleScript(moduleName, Arrays.asList(jarFile), dependencies));
        }
    }

    private void createMgmtUsersProperties() {
        if (!this.getUsers().isEmpty()) {
            StringBuilder managementToken = new StringBuilder("# JBoss mgmt-users.properties file generated by CARGO\n");
            for (User user : this.getUsers()) {
                managementToken.append(WildFlyUserUtils.generateUserPasswordLine(user, "ManagementRealm"));
            }
            this.getFileHandler().writeTextFile(this.getFileHandler().append(this.getHome(), "/configuration/mgmt-users.properties"), managementToken.toString(), "UTF-8");
        }
    }

    private void createApplicationUsersProperties() {
        if (!this.getUsers().isEmpty()) {
            StringBuilder usersToken = new StringBuilder("# JBoss application-users.properties file generated by CARGO\n");
            for (User user : this.getUsers()) {
                usersToken.append(WildFlyUserUtils.generateUserPasswordLine(user, "ApplicationRealm"));
            }
            this.getFileHandler().writeTextFile(this.getFileHandler().append(this.getHome(), "/configuration/application-users.properties"), usersToken.toString(), "UTF-8");
        }
    }

    private void createApplicationRolesProperties() {
        if (!this.getUsers().isEmpty()) {
            StringBuilder rolesToken = new StringBuilder("# JBoss application-roles.properties file generated by CARGO\n");
            for (User user : this.getUsers()) {
                rolesToken.append(user.getName());
                rolesToken.append("=");
                for (String role : user.getRoles()) {
                    rolesToken.append(role);
                    rolesToken.append(",");
                }
                rolesToken.append('\n');
            }
            this.getFileHandler().writeTextFile(this.getFileHandler().append(this.getHome(), "/configuration/application-roles.properties"), rolesToken.toString(), "UTF-8");
        }
    }
}

