/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.configuration.script.ScriptCommand;
import org.codehaus.cargo.container.jboss.JBoss7xInstalledLocalDeployer;
import org.codehaus.cargo.container.wildfly.internal.AbstractWildFlyInstalledLocalContainer;
import org.codehaus.cargo.container.wildfly.internal.AbstractWildFlyStandaloneLocalConfiguration;
import org.codehaus.cargo.container.wildfly.internal.WildFly9xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.wildfly.internal.configuration.factory.WildFly9xCliConfigurationFactory;
import org.codehaus.cargo.container.wildfly.internal.configuration.factory.WildFlyCliConfigurationFactory;
import org.codehaus.cargo.container.wildfly.internal.util.WildFlyModuleUtils;

public class WildFly9xStandaloneLocalConfiguration
extends AbstractWildFlyStandaloneLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new WildFly9xStandaloneLocalConfigurationCapability();
    private WildFly9xCliConfigurationFactory factory = new WildFly9xCliConfigurationFactory(this);

    public WildFly9xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    @Override
    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    @Override
    public WildFlyCliConfigurationFactory getConfigurationFactory() {
        return this.factory;
    }

    @Override
    protected void doConfigure(LocalContainer c) throws Exception {
        String deployments;
        String scriptPath;
        AbstractWildFlyInstalledLocalContainer container = (AbstractWildFlyInstalledLocalContainer)c;
        super.doConfigure(c);
        ArrayList<ScriptCommand> configurationScript = new ArrayList<ScriptCommand>();
        configurationScript.add(this.factory.startEmbedServerScript());
        configurationScript.add(this.factory.configurePortsScript());
        configurationScript.add(this.factory.loggingScript());
        for (String classpathElement : container.getExtraClasspath()) {
            this.addModuleScript(classpathElement, container, configurationScript);
        }
        for (String classpathElement : container.getSharedClasspath()) {
            this.addModuleScript(classpathElement, container, configurationScript);
        }
        for (DataSource dataSource : this.getDataSources()) {
            String driverModule = WildFlyModuleUtils.getDataSourceDriverModuleName(container, dataSource);
            configurationScript.add(this.factory.dataSourceDriverScript(dataSource, driverModule));
            configurationScript.add(this.factory.dataSourceScript(dataSource));
        }
        for (Resource resource : this.getResources()) {
            configurationScript.add(this.factory.resourceScript(resource));
        }
        for (Map.Entry entry : container.getSystemProperties().entrySet()) {
            configurationScript.add(this.factory.systemPropertyScript((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Map.Entry entry : this.getProperties().entrySet()) {
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith("cargo.wildfly.script.cli.embedded")) continue;
            scriptPath = (String)entry.getValue();
            configurationScript.add(this.factory.customScript(scriptPath));
        }
        container.executeScript(configurationScript);
        for (Map.Entry entry : this.getProperties().entrySet()) {
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith("cargo.wildfly.script.cli.offline")) continue;
            scriptPath = (String)entry.getValue();
            container.executeScriptFiles(Arrays.asList(scriptPath));
        }
        String string = container.getConfiguration().getPropertyValue("cargo.jboss.deployment.dir");
        if (string != null && !string.equals("")) {
            container.getLogger().info("Using non-default deployment target directory " + string, this.getClass().getName());
            deployments = this.getFileHandler().append(this.getHome(), string);
        } else {
            deployments = this.getFileHandler().append(this.getHome(), "deployments");
        }
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployments, "cargocpc.war"));
        JBoss7xInstalledLocalDeployer deployer = new JBoss7xInstalledLocalDeployer(container);
        deployer.deploy(this.getDeployables());
    }
}

