/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.script.ScriptCommand;
import org.codehaus.cargo.container.jboss.JBoss7xInstalledLocalDeployer;
import org.codehaus.cargo.container.property.TransactionSupport;
import org.codehaus.cargo.container.wildfly.internal.AbstractWildFlyInstalledLocalContainer;
import org.codehaus.cargo.container.wildfly.internal.AbstractWildFlyStandaloneLocalConfiguration;
import org.codehaus.cargo.container.wildfly.internal.WildFly8xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.wildfly.internal.configuration.factory.WildFly8xCliConfigurationFactory;
import org.codehaus.cargo.container.wildfly.internal.configuration.factory.WildFlyCliConfigurationFactory;
import org.codehaus.cargo.container.wildfly.internal.util.WildFlyLogUtils;
import org.codehaus.cargo.container.wildfly.internal.util.WildFlyModuleUtils;

public class WildFly8xStandaloneLocalConfiguration
extends AbstractWildFlyStandaloneLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new WildFly8xStandaloneLocalConfigurationCapability();
    private WildFly8xCliConfigurationFactory factory = new WildFly8xCliConfigurationFactory(this);

    public WildFly8xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    @Override
    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    @Override
    public WildFlyCliConfigurationFactory getConfigurationFactory() {
        return this.factory;
    }

    @Override
    protected void doConfigure(LocalContainer c) throws Exception {
        String deployments;
        AbstractWildFlyInstalledLocalContainer container = (AbstractWildFlyInstalledLocalContainer)c;
        super.doConfigure(c);
        String configurationXmlFile = "configuration/" + this.getPropertyValue("cargo.jboss.configuration") + ".xml";
        String wildFlyLogLevel = WildFlyLogUtils.getWildFlyLogLevel(this.getPropertyValue("cargo.logging"));
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='ajp']", "port", "cargo.jboss.ajp.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='management-http']", "port", "cargo.jboss.management-http.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='http']", "port", "cargo.servlet.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group", "port-offset", "cargo.port.offset");
        this.addXmlReplacement(configurationXmlFile, "//server/profile/subsystem/root-logger/level", "name", wildFlyLogLevel);
        ArrayList<ScriptCommand> configurationScript = new ArrayList<ScriptCommand>();
        for (String classpathElement : container.getExtraClasspath()) {
            this.addModuleScript(classpathElement, container, configurationScript);
        }
        for (String classpathElement : container.getSharedClasspath()) {
            this.addModuleScript(classpathElement, container, configurationScript);
        }
        container.executeScript(configurationScript);
        this.configureDataSources(container, configurationXmlFile);
        String altDeployDir = container.getConfiguration().getPropertyValue("cargo.jboss.deployment.dir");
        if (altDeployDir != null && !altDeployDir.equals("")) {
            container.getLogger().info("Using non-default deployment target directory " + altDeployDir, this.getClass().getName());
            deployments = this.getFileHandler().append(this.getHome(), altDeployDir);
        } else {
            deployments = this.getFileHandler().append(this.getHome(), "deployments");
        }
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployments, "cargocpc.war"));
        JBoss7xInstalledLocalDeployer deployer = new JBoss7xInstalledLocalDeployer(container);
        deployer.deploy(this.getDeployables());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureDataSources(InstalledLocalContainer container, String configurationXmlFile) throws IOException {
        String configurationXml = this.getFileHandler().append(this.getHome(), configurationXmlFile);
        String tmpDir = this.getFileHandler().createUniqueTmpDirectory();
        try {
            ArrayList<String> driversList = new ArrayList<String>();
            StringBuilder datasources = new StringBuilder();
            StringBuilder drivers = new StringBuilder();
            for (DataSource dataSource : this.getDataSources()) {
                String moduleName = WildFlyModuleUtils.getDataSourceDriverModuleName(container, dataSource);
                FilterChain filterChain = this.createFilterChain();
                this.getAntUtils().addTokenToFilterChain(filterChain, "moduleName", moduleName);
                this.getAntUtils().addTokenToFilterChain(filterChain, "driverClass", dataSource.getDriverClass());
                String jndiName = dataSource.getJndiLocation();
                if (!jndiName.startsWith("java:/")) {
                    jndiName = "java:/" + jndiName;
                    this.getLogger().warn("JBoss 7 requires datasource JNDI names to start with java:/, hence changing the given JNDI name to: " + jndiName, this.getClass().getName());
                }
                this.getAntUtils().addTokenToFilterChain(filterChain, "jndiName", jndiName);
                this.getAntUtils().addTokenToFilterChain(filterChain, "url", dataSource.getUrl());
                this.getAntUtils().addTokenToFilterChain(filterChain, "username", dataSource.getUsername());
                this.getAntUtils().addTokenToFilterChain(filterChain, "password", dataSource.getPassword());
                String xa = "";
                if (TransactionSupport.XA_TRANSACTION.equals(dataSource.getTransactionSupport())) {
                    xa = "-xa";
                }
                if (!driversList.contains(dataSource.getDriverClass())) {
                    driversList.add(dataSource.getDriverClass());
                    String temporaryDriver = this.getFileHandler().append(tmpDir, "driver.xml");
                    this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/wildfly-8/datasource/jboss-driver" + xa + ".xml", temporaryDriver, this.getFileHandler(), filterChain, "UTF-8");
                    drivers.append("\n");
                    drivers.append(this.getFileHandler().readTextFile(temporaryDriver, "UTF-8"));
                }
                String temporaryDatasource = this.getFileHandler().append(tmpDir, "datasource.xml");
                this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/wildfly-8/datasource/jboss-datasource.xml", temporaryDatasource, this.getFileHandler(), filterChain, "UTF-8");
                datasources.append("\n");
                datasources.append(this.getFileHandler().readTextFile(temporaryDatasource, "UTF-8"));
            }
            HashMap<String, String> replacements = new HashMap<String, String>(1);
            replacements.put("<drivers>", datasources + "<drivers>" + drivers);
            this.getFileHandler().replaceInFile(configurationXml, replacements, "UTF-8");
        }
        finally {
            this.getFileHandler().delete(tmpDir);
        }
    }
}

