/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.util.CargoException;

public final class ContainerUtils {
    private static final int SLEEP = 100;

    private ContainerUtils() {
    }

    public static URL getCPCURL(Configuration configuration) {
        try {
            String hostname = configuration.getPropertyValue("cargo.hostname");
            if ("0.0.0.0".equals(hostname) || "::0".equals(hostname)) {
                hostname = "localhost";
            }
            return new URL(configuration.getPropertyValue("cargo.protocol") + "://" + hostname + ":" + configuration.getPropertyValue("cargo.servlet.port") + "/cargocpc/index.html");
        }
        catch (MalformedURLException e) {
            throw new ContainerException("Failed to compute CPC URL", e);
        }
    }

    public static void waitTillContainerIsStopped(Container container) {
        while (container.getState() == State.STARTED) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new CargoException("Aborting container wait.", e);
            }
        }
    }
}

