/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer;
import org.codehaus.cargo.container.jboss.internal.JBossInstalledLocalContainer;
import org.codehaus.cargo.container.jboss.internal.JBossStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.property.TransactionSupport;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.util.CargoException;

public class JBossStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new JBossStandaloneLocalConfigurationCapability();
    protected JBossInstalledLocalContainer jbossContainer;
    protected String log4jFileName = "log4j.xml";

    public JBossStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "1099");
        this.setProperty("cargo.jboss.configuration", "default");
        this.setProperty("cargo.jboss.naming.port", "1098");
        this.setProperty("cargo.jboss.classloading.webservice.port", "8083");
        this.setProperty("cargo.jboss.jrmp.port", "1090");
        this.setProperty("cargo.jboss.jrmp.invoker.port", "4444");
        this.setProperty("cargo.jboss.invoker.pool.port", "4445");
        this.setProperty("cargo.jboss.remoting.transport.port", "4446");
        this.setProperty("cargo.jboss.ejb3.remoting.port", "3873");
        this.setProperty("cargo.jboss.transaction.recoveryManager.port", "4712");
        this.setProperty("cargo.jboss.transaction.statusManager.port", "4713");
    }

    @Override
    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    public JBossInstalledLocalContainer getJbossContainer() {
        return this.jbossContainer;
    }

    @Override
    protected void doConfigure(LocalContainer container) throws Exception {
        String[] cargoFiles;
        this.getLogger().info("Configuring JBoss using the [" + this.getPropertyValue("cargo.jboss.configuration") + "] server configuration", this.getClass().getName());
        this.setupConfigurationDir();
        this.jbossContainer = (JBossInstalledLocalContainer)container;
        FilterChain filterChain = this.createJBossFilterChain(this.jbossContainer);
        String deployDir = this.getFileHandler().createDirectory(this.getHome(), "/deploy");
        String libDir = this.getFileHandler().createDirectory(this.getHome(), "/lib");
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "/conf");
        String clustered = this.jbossContainer.getConfiguration().getPropertyValue("cargo.jboss.clustered");
        if (Boolean.valueOf(clustered).booleanValue()) {
            String string = this.getFileHandler().createDirectory(this.getHome(), "/farm");
        }
        for (String cargoFile : cargoFiles = new String[]{"cargo-binding.xml", "jboss-service.xml"}) {
            this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/" + this.jbossContainer.getId() + "/" + cargoFile, new File(confDir, cargoFile), filterChain, "UTF-8");
        }
        this.copyExternalResources(new File(this.jbossContainer.getConfDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(confDir), cargoFiles);
        String jbossLog4jXml = this.getFileHandler().append(confDir, this.log4jFileName);
        HashMap<String, String> replacements = new HashMap<String, String>(2);
        replacements.put("<param name=\"Append\" value=\"false\"/>", "<param name=\"Append\" value=\"" + Boolean.toString(container.isAppend()) + "\"/>");
        replacements.put("<param name=\"Append\" value=\"true\"/>", "<param name=\"Append\" value=\"" + Boolean.toString(container.isAppend()) + "\"/>");
        this.getFileHandler().replaceInFile(jbossLog4jXml, replacements, "UTF-8", true);
        this.copyExternalResources(new File(this.jbossContainer.getDeployDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(deployDir));
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(this.getHome(), "/deploy/cargocpc.war"));
        JBossInstalledLocalDeployer deployer = new JBossInstalledLocalDeployer(this.jbossContainer);
        deployer.deploy(this.getDeployables());
        this.deployDatasources(deployDir);
    }

    protected void deployDatasources(String deployDir) throws IOException {
        for (DataSource ds : this.getDataSources()) {
            String sourceFile = "org/codehaus/cargo/container/internal/resources/jboss-ds/";
            if (TransactionSupport.NO_TRANSACTION.equals(ds.getTransactionSupport())) {
                sourceFile = sourceFile + "jboss-ds-no-transaction.xml";
            } else if (TransactionSupport.LOCAL_TRANSACTION.equals(ds.getTransactionSupport())) {
                sourceFile = sourceFile + "jboss-ds-local-transaction.xml";
            } else if (TransactionSupport.XA_TRANSACTION.equals(ds.getTransactionSupport())) {
                sourceFile = sourceFile + "jboss-ds-xa-transaction.xml";
            } else {
                throw new CargoException("Unknown transaction type " + ds.getTransactionSupport());
            }
            FilterChain filterChain = this.createFilterChain();
            this.getAntUtils().addTokenToFilterChain(filterChain, "jndiName", ds.getJndiLocation());
            this.getAntUtils().addTokenToFilterChain(filterChain, "url", ds.getUrl());
            this.getAntUtils().addTokenToFilterChain(filterChain, "driverClass", ds.getDriverClass());
            this.getAntUtils().addTokenToFilterChain(filterChain, "username", ds.getUsername());
            this.getAntUtils().addTokenToFilterChain(filterChain, "password", ds.getPassword());
            this.getResourceUtils().copyResource(sourceFile, new File(this.getFileHandler().append(deployDir, "cargo-" + ds.getId() + "-ds.xml")), filterChain, "UTF-8");
        }
    }

    @Override
    public void verify() {
        super.verify();
        String configurationName = this.getPropertyValue("cargo.jboss.configuration");
        if (configurationName == null || configurationName.isEmpty()) {
            throw new ContainerException("Invalid JBoss configuration: [cargo.jboss.configuration] doesn't exist.");
        }
    }

    protected void copyExternalResources(File sourceDir, File destDir) throws IOException {
        this.copyExternalResources(sourceDir, destDir, null);
    }

    protected void copyExternalResources(File sourceDir, File destDir, String[] cargoFiles) throws IOException {
        File[] sourceFiles = sourceDir.listFiles();
        if (sourceFiles != null) {
            for (int i = 0; i < sourceFiles.length; ++i) {
                if (this.isExcluded(cargoFiles, sourceFiles[i].getName())) continue;
                if (sourceFiles[i].isDirectory()) {
                    this.getFileHandler().createDirectory(destDir.getPath(), sourceFiles[i].getName());
                    this.copyExternalResources(sourceFiles[i], new File(destDir, sourceFiles[i].getName()), cargoFiles);
                    continue;
                }
                FileOutputStream fops = new FileOutputStream(new File(destDir, sourceFiles[i].getName()));
                FileInputStream fips = new FileInputStream(sourceFiles[i]);
                this.getFileHandler().copy(fips, fops);
                fips.close();
                fops.close();
            }
        }
    }

    private boolean isExcluded(String[] cargoFiles, String filename) {
        if (cargoFiles == null) {
            return false;
        }
        for (String cargoFile : cargoFiles) {
            if (!cargoFile.equals(filename)) continue;
            return true;
        }
        return false;
    }

    protected FilterChain createJBossFilterChain(JBossInstalledLocalContainer container) throws MalformedURLException {
        FilterChain filterChain = this.createFilterChain();
        String[] version = this.jbossContainer.getName().split(" ");
        if (version.length < 2) {
            throw new IllegalArgumentException("Cannot read JBoss version number from name " + this.jbossContainer.getName());
        }
        if (version[1].length() < 1) {
            throw new IllegalArgumentException("Cannot get the major version for version " + version[1]);
        }
        String majorVersion = version[1].substring(0, 1);
        if (version[1].length() < 3) {
            throw new IllegalArgumentException("Cannot get the minor version for version " + version[1]);
        }
        String minorVersion = version[1].substring(2, 3);
        if (version[1].length() < 5) {
            throw new IllegalArgumentException("Cannot get the revision for version " + version[1]);
        }
        String revisionVersion = version[1].substring(4, 5);
        if (Integer.valueOf(majorVersion) > 3 || Integer.valueOf(minorVersion) > 2 || Integer.valueOf(revisionVersion) > 7) {
            this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.server.mode.attr", "<attribute name=\"ServerMode\">true</attribute>");
        }
        String bindingXmlFile = this.getFileHandler().append(this.getHome(), "conf/cargo-binding.xml");
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.binding.url", this.getFileHandler().getURL(bindingXmlFile));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.rmi.port", this.getPropertyValue("cargo.rmi.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.naming.port", this.getPropertyValue("cargo.jboss.naming.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.classloading.webservice.port", this.getPropertyValue("cargo.jboss.classloading.webservice.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.jrmp.port", this.getPropertyValue("cargo.jboss.jrmp.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.jrmp.invoker.port", this.getPropertyValue("cargo.jboss.jrmp.invoker.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.invoker.pool.port", this.getPropertyValue("cargo.jboss.invoker.pool.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.remoting.transport.port", this.getPropertyValue("cargo.jboss.remoting.transport.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.ejb3.remoting.port", this.getPropertyValue("cargo.jboss.ejb3.remoting.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.transaction.recoveryManager.port", this.getPropertyValue("cargo.jboss.transaction.recoveryManager.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.transaction.statusManager.port", this.getPropertyValue("cargo.jboss.transaction.statusManager.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.servlet.port", this.getPropertyValue("cargo.servlet.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.logging", this.getJBossLogLevel(this.getPropertyValue("cargo.logging")));
        File libDir = new File(container.getLibDir(this.getPropertyValue("cargo.jboss.configuration")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.server.lib.url", libDir.toURI().toURL().toString());
        StringBuilder buffer = new StringBuilder();
        File deployDir = new File(container.getDeployDir(this.getPropertyValue("cargo.jboss.configuration")));
        buffer.append("deploy/, ").append(deployDir.toURI().toURL().toString());
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.server.deploy.url", "deploy/");
        this.getAntUtils().addTokenToFilterChain(filterChain, "jboss.shared.classpath", this.getSharedClasspathXml(container));
        return filterChain;
    }

    protected String getSharedClasspathXml(JBossInstalledLocalContainer container) throws MalformedURLException {
        String[] sharedClassPath = container.getSharedClasspath();
        StringBuilder tmp = new StringBuilder();
        if (sharedClassPath != null) {
            for (String element : sharedClassPath) {
                String fileName = this.getFileHandler().getName(element);
                String directoryName = this.getFileHandler().getParent(element);
                URL directoryUrl = new File(directoryName).toURI().toURL();
                tmp.append("<classpath codebase=\"" + directoryUrl + "\" archives=\"" + fileName + "\"/>");
                tmp.append("\n");
            }
        }
        String sharedClassPathString = tmp.toString();
        this.getLogger().debug("Shared loader classpath is " + sharedClassPathString, this.getClass().getName());
        return sharedClassPathString;
    }

    private String getJBossLogLevel(String cargoLogLevel) {
        String level = LoggingLevel.LOW.equalsLevel(cargoLogLevel) ? "ERROR" : (LoggingLevel.MEDIUM.equalsLevel(cargoLogLevel) ? "WARN" : "INFO");
        return level;
    }

    public String toString() {
        return "JBoss Standalone Configuration";
    }
}

