/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jboss.deployable.JBossWAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class JBossInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    public JBossInstalledLocalDeployer(LocalContainer container) {
        super(container);
    }

    @Override
    public String getDeployableDir(Deployable deployable) {
        String clustered = this.getContainer().getConfiguration().getPropertyValue("cargo.jboss.clustered");
        if (Boolean.valueOf(clustered).booleanValue()) {
            return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "farm");
        }
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "deploy");
    }

    @Override
    protected String getDeployableName(Deployable deployable) {
        JBossWAR jbossWar;
        if (deployable instanceof JBossWAR && (jbossWar = (JBossWAR)deployable).containsJBossWebContext()) {
            return this.getFileHandler().getName(deployable.getFile());
        }
        String deployableName = super.getDeployableName(deployable);
        if (DeployableType.WAR.equals(deployable.getType()) && deployable.isExpanded()) {
            deployableName = deployableName + ".war";
        }
        return deployableName;
    }

    @Override
    public void undeploy(Deployable deployable) {
        if (deployable.getType() == DeployableType.WAR) {
            WAR war = (WAR)deployable;
            this.undeployFile(this.getDeployableDir(deployable), war.getContext() + ".war");
        } else if (deployable.getType() == DeployableType.EAR) {
            EAR ear = (EAR)deployable;
            this.undeployFile(this.getDeployableDir(deployable), ear.getName() + ".ear");
        } else if (deployable.getType() == DeployableType.FILE || deployable.getType() == DeployableType.SAR) {
            String fileName = this.getFileHandler().getName(deployable.getFile());
            this.undeployFile(this.getDeployableDir(deployable), fileName);
        } else {
            super.undeploy(deployable);
            return;
        }
    }

    private boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    private void undeployFile(String directory, String file) {
        String fileName = this.getFileHandler().append(directory, file);
        if (this.fileExists(fileName)) {
            this.getLogger().info("Undeploying [" + fileName + "]...", this.getClass().getName());
            this.getFileHandler().delete(fileName);
        } else {
            this.getLogger().info("Couldn't not find file to undeploy [" + fileName + "]", this.getClass().getName());
        }
    }
}

