/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarFile;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ScriptingCapableContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.script.ScriptCommand;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.jboss.internal.JBoss7xContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.util.CargoException;

public class JBoss7xInstalledLocalContainer
extends AbstractInstalledLocalContainer
implements ScriptingCapableContainer {
    public static final String ID = "jboss7x";
    private static final ContainerCapability CAPABILITY = new JBoss7xContainerCapability();
    protected String version;

    public JBoss7xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "JBoss " + this.getVersion("7.x");
    }

    @Override
    public ContainerCapability getCapability() {
        return CAPABILITY;
    }

    public String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                File configAdminFile = null;
                File configAdminDirectory = this.getConfigAdminDirectory();
                if (configAdminDirectory.isDirectory()) {
                    File[] contents;
                    for (File content : contents = configAdminDirectory.listFiles()) {
                        if (!content.getName().endsWith(".jar")) continue;
                        if (configAdminFile != null) {
                            throw new IllegalStateException("The directory " + configAdminDirectory + " contains more than one JAR.");
                        }
                        configAdminFile = content;
                    }
                    if (configAdminFile == null) {
                        throw new IllegalStateException("The directory " + configAdminDirectory + " does not contain any JAR files.");
                    }
                } else {
                    throw new IllegalArgumentException(configAdminDirectory + " is not a directory.");
                }
                JarFile jarFile = new JarFile(configAdminFile);
                version = jarFile.getManifest().getMainAttributes().getValue("Bundle-Version");
                if (version == null) {
                    version = jarFile.getManifest().getMainAttributes().getValue("Implementation-Version");
                }
                if (version == null) {
                    version = defaultVersion;
                    this.getLogger().debug("Couldn't find Bundle-Version in the MANIFEST of " + configAdminFile, this.getClass().getName());
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getLogger().debug("Failed to find JBoss version, base error [" + e.getMessage() + "]", this.getClass().getName());
            }
            this.getLogger().info("Parsed JBoss version = [" + version + "]", this.getClass().getName());
            this.version = version;
        }
        return version;
    }

    protected File getConfigAdminDirectory() {
        return new File(this.getHome(), "bundles/org/jboss/as/osgi/configadmin/main");
    }

    @Override
    protected void addRuntimeArgs(JvmLauncher java) {
    }

    @Override
    protected void doStart(JvmLauncher java) throws Exception {
        this.copyExtraClasspathJars();
        this.setProperties(java);
        java.setJarFile(new File(this.getHome(), "jboss-modules.jar"));
        String modules = this.getConfiguration().getPropertyValue("cargo.jboss.modules.dir");
        if (!new File(modules).isAbsolute()) {
            modules = this.getFileHandler().append(this.getHome(), modules);
        }
        java.addAppArguments("-mp", modules, "-logmodule", "org.jboss.logmanager", "-jaxpmodule", "javax.xml.jaxp-provider", "org.jboss.as.standalone", "--server-config=" + this.getConfiguration().getPropertyValue("cargo.jboss.configuration") + ".xml");
        String runtimeArgs = this.getConfiguration().getPropertyValue("cargo.runtime.args");
        if (runtimeArgs != null) {
            runtimeArgs = runtimeArgs.replace('\n', ' ');
            runtimeArgs = runtimeArgs.replace('\r', ' ');
            runtimeArgs = runtimeArgs.replace('\t', ' ');
            java.addAppArgumentLine(runtimeArgs);
        }
        java.start();
    }

    @Override
    protected void executePostStartTasks() throws Exception {
        Map<String, String> properties = this.getConfiguration().getProperties();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String propertyName = property.getKey();
            if (!propertyName.startsWith("cargo.jboss.script.cli.online")) continue;
            String scriptPath = property.getValue();
            this.executeScriptFiles(Arrays.asList(scriptPath));
        }
    }

    @Override
    protected void doStop(JvmLauncher java) throws Exception {
        String host = this.getConfiguration().getPropertyValue("cargo.hostname");
        String port = this.getConfiguration().getPropertyValue("cargo.jboss.management-native.port");
        java.setJarFile(new File(this.getHome(), "jboss-modules.jar"));
        java.addAppArguments("-mp", this.getHome() + "/modules", "-logmodule", "org.jboss.logmanager", "org.jboss.as.cli", "--connect", "--controller=" + host + ":" + port, "command=:shutdown");
        String username = this.getConfiguration().getPropertyValue("cargo.remote.username");
        if (username != null && !username.trim().isEmpty()) {
            String password = this.getConfiguration().getPropertyValue("cargo.remote.password");
            java.addAppArguments("--user=" + username, "--password=" + password);
        }
        java.start();
    }

    protected void setProperties(JvmLauncher java) {
        java.setSystemProperty("org.jboss.boot.log.file", this.getConfiguration().getHome() + "/log/boot.log");
        try {
            java.setSystemProperty("logging.configuration", new File(this.getConfiguration().getHome() + "/configuration/logging.properties").toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            throw new CargoException("Cannot create logging file URL.", e);
        }
        java.setSystemProperty("jboss.home.dir", this.getHome());
        java.setSystemProperty("jboss.server.base.dir", this.getConfiguration().getHome());
        Map<String, String> systemProperties = this.getSystemProperties();
        if (!systemProperties.containsKey("jboss.bind.address")) {
            String hostname = this.getConfiguration().getPropertyValue("cargo.hostname");
            if ("localhost".equals(hostname)) {
                hostname = "0.0.0.0";
            }
            java.setSystemProperty("jboss.bind.address", hostname);
        }
    }

    protected void copyExtraClasspathJars() throws IOException {
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add("javax.api");
        dependencies.add("javax.transaction.api");
        TreeSet<String> classpath = new TreeSet<String>();
        if (this.getExtraClasspath() != null && this.getExtraClasspath().length != 0) {
            for (String classpathElement : this.getExtraClasspath()) {
                classpath.add(classpathElement);
            }
        }
        if (this.getSharedClasspath() != null && this.getSharedClasspath().length != 0) {
            for (String classpathElement : this.getSharedClasspath()) {
                classpath.add(classpathElement);
            }
        }
        for (String classpathElement : classpath) {
            String moduleName = this.getFileHandler().getName(classpathElement);
            moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
            moduleName = moduleName.replace('.', '-');
            String folder = this.getHome() + "/modules/org/codehaus/cargo/classpath/" + moduleName + "/main";
            this.getFileHandler().mkdirs(folder);
            StringBuilder dependenciesXml = new StringBuilder();
            for (String dependency : dependencies) {
                dependenciesXml.append("\n    <module name=\"" + dependency + "\"/>");
            }
            dependencies.add("org.codehaus.cargo.classpath." + moduleName);
            FilterChain filterChain = new FilterChain();
            this.getAntUtils().addTokenToFilterChain(filterChain, "moduleName", moduleName);
            this.getAntUtils().addTokenToFilterChain(filterChain, "dependencies", dependenciesXml.toString());
            this.getFileHandler().copyFile(classpathElement, this.getFileHandler().append(folder, moduleName + ".jar"));
            this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/jboss-module/jboss-module.xml", this.getFileHandler().append(folder, "module.xml"), this.getFileHandler(), filterChain, "UTF-8");
        }
    }

    @Override
    public void executeScript(List<ScriptCommand> configurationScript) {
        String newLine = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        for (ScriptCommand configuration : configurationScript) {
            buffer.append(configuration.readScript());
            buffer.append(newLine);
        }
        this.getLogger().debug("Sending CLI script: " + newLine + buffer.toString(), this.getClass().getName());
        try {
            File tempFile = File.createTempFile("jboss-", ".cli");
            tempFile.deleteOnExit();
            this.getFileHandler().writeTextFile(tempFile.getAbsolutePath(), buffer.toString(), null);
            this.executeScriptFiles(Arrays.asList(tempFile.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new CargoException("Cannot create temporary CLI script file.", e);
        }
    }

    @Override
    public void executeScriptFiles(List<String> scriptFilePaths) {
        for (String scriptFilePath : scriptFilePaths) {
            File scriptFile = new File(scriptFilePath);
            if (scriptFile.isAbsolute() && !scriptFile.exists()) {
                this.getLogger().warn(String.format("Script file %s doesn't exists.", scriptFilePath), this.getClass().getName());
                continue;
            }
            JvmLauncher java = this.createJvmLauncher(false);
            this.addCliArguments(java);
            this.setProperties(java);
            java.addAppArguments("--file=" + scriptFile);
            int result = java.execute();
            if (result == 0) continue;
            throw new ContainerException("Failure when invoking CLI script, java returned " + result);
        }
    }

    private void addCliArguments(JvmLauncher java) {
        String host = this.getConfiguration().getPropertyValue("cargo.hostname");
        String port = this.getConfiguration().getPropertyValue("cargo.jboss.management-native.port");
        java.setJarFile(new File(this.getHome(), "jboss-modules.jar"));
        String modules = this.getConfiguration().getPropertyValue("cargo.jboss.modules.dir");
        if (!new File(modules).isAbsolute()) {
            modules = this.getFileHandler().append(this.getHome(), modules);
        }
        java.addAppArguments("-mp", modules, "org.jboss.as.cli");
        if (this.isOnline()) {
            java.addAppArguments("--connect", "--controller=" + host + ":" + port);
        }
    }

    public boolean isOnline() {
        HttpUtils httpUtils = new HttpUtils();
        return httpUtils.ping(ContainerUtils.getCPCURL(this.getConfiguration()));
    }
}

