/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jboss.JBoss7xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jboss.internal.JBoss71xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.property.User;

public class JBoss71xStandaloneLocalConfiguration
extends JBoss7xStandaloneLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new JBoss71xStandaloneLocalConfigurationCapability();

    public JBoss71xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.jboss.ajp.port", "8009");
        this.setProperty("cargo.jboss.transaction.recoveryManager.port", "4712");
        this.setProperty("cargo.jboss.transaction.statusManager.port", "4713");
        this.getProperties().remove("cargo.rmi.port");
        this.getProperties().remove("cargo.jboss.jrmp.port");
        this.getProperties().remove("cargo.jboss.jmx.port");
    }

    @Override
    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    @Override
    public void configure(LocalContainer container) {
        super.configure(container);
        if (!this.getUsers().isEmpty()) {
            StringBuilder usersToken = new StringBuilder("# JBoss application-users.properties file generated by CARGO\n");
            StringBuilder rolesToken = new StringBuilder("# JBoss application-roles.properties file generated by CARGO\n");
            for (User user : this.getUsers()) {
                usersToken.append(this.generateUserPasswordLine(user, "ApplicationRealm"));
                rolesToken.append(user.getName());
                rolesToken.append("=");
                for (String role : user.getRoles()) {
                    rolesToken.append(role);
                    rolesToken.append(",");
                }
                rolesToken.append('\n');
            }
            this.getFileHandler().writeTextFile(this.getFileHandler().append(this.getHome(), "/configuration/application-users.properties"), usersToken.toString(), "UTF-8");
            this.getFileHandler().writeTextFile(this.getFileHandler().append(this.getHome(), "/configuration/application-roles.properties"), rolesToken.toString(), "UTF-8");
        }
    }

    @Override
    protected void doConfigure(LocalContainer c) throws Exception {
        super.doConfigure(c);
        String configurationXmlFile = "configuration/" + this.getPropertyValue("cargo.jboss.configuration") + ".xml";
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='ajp']", "port", "cargo.jboss.ajp.port");
        this.removeXmlReplacement(configurationXmlFile, "//server/management/management-interfaces/native-interface[@interface='management']", "port");
        this.removeXmlReplacement(configurationXmlFile, "//server/management/management-interfaces/http-interface[@interface='management']", "port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='management-native']", "port", "cargo.jboss.management-native.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='management-http']", "port", "cargo.jboss.management-http.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='txn-recovery-environment']", "port", "cargo.jboss.transaction.recoveryManager.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='txn-status-manager']", "port", "cargo.jboss.transaction.statusManager.port");
        this.removeXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='jndi']", "port");
        this.removeXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='jmx-connector-registry']", "port");
        this.removeXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='jmx-connector-server']", "port");
        this.removeXmlReplacement(configurationXmlFile, "//server/profile/subsystem/periodic-rotating-file-handler/level", "name");
    }
}

