/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public final class ComplexPropertyUtils {
    private ComplexPropertyUtils() {
    }

    public static List<List<String>> parseProperty(String property) {
        return ComplexPropertyUtils.parseProperty(property, "|", ":");
    }

    public static List<List<String>> parseProperty(String property, String propertyDelimiter, String propertyElementDelimiter) {
        ArrayList<List<String>> parsedProperty = new ArrayList<List<String>>();
        if (property != null && !property.isEmpty()) {
            StringTokenizer propertyEntries = new StringTokenizer(property, propertyDelimiter);
            while (propertyEntries.hasMoreTokens()) {
                String propertyEntry = propertyEntries.nextToken().trim();
                if (propertyEntry == null || propertyEntry.isEmpty()) continue;
                ArrayList<String> propertyValueList = new ArrayList<String>();
                StringTokenizer propertyValues = new StringTokenizer(propertyEntry, propertyElementDelimiter);
                while (propertyValues.hasMoreTokens()) {
                    propertyValueList.add(propertyValues.nextToken().trim());
                }
                parsedProperty.add(propertyValueList);
            }
        }
        return parsedProperty;
    }

    public static List<String> parseProperty(String property, String propertyDelimiter) {
        ArrayList<String> parsedProperty = new ArrayList<String>();
        if (property != null && !property.isEmpty()) {
            StringTokenizer propertyEntries = new StringTokenizer(property, propertyDelimiter);
            while (propertyEntries.hasMoreTokens()) {
                String propertyEntry = propertyEntries.nextToken().trim();
                if (propertyEntry == null || propertyEntry.isEmpty()) continue;
                parsedProperty.add(propertyEntry);
            }
        }
        return parsedProperty;
    }

    public static String joinOnDelimiter(List<String> toJoin, char delimiter) {
        StringBuilder buf = new StringBuilder();
        Iterator<String> it = toJoin.iterator();
        while (it.hasNext()) {
            String value = it.next();
            buf.append(value);
            if (!it.hasNext()) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }
}

