/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployer;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.util.log.LoggedObject;

public abstract class AbstractDeployableMonitor
extends LoggedObject
implements DeployableMonitor {
    private List<DeployableMonitorListener> listeners = new ArrayList<DeployableMonitorListener>();
    private long timeout;

    public AbstractDeployableMonitor() {
        this(20000L);
    }

    public AbstractDeployableMonitor(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void registerListener(DeployableMonitorListener listener) {
        this.listeners.add(listener);
    }

    protected void notifyListeners(boolean isDeployed) {
        for (DeployableMonitorListener listener : this.listeners) {
            this.getLogger().debug("Notifying monitor listener [" + listener + "]", this.getClass().getName());
            if (isDeployed) {
                listener.deployed();
                continue;
            }
            listener.undeployed();
        }
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }
}

