/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.codehaus.cargo.util.internal.log.AbstractLogger;
import org.codehaus.cargo.util.log.LogLevel;

public class AntLogger
extends AbstractLogger {
    private Project project;
    private Target target;
    private Task task;
    private Map<LogLevel, Integer> levelMapper;

    public AntLogger(Task task) {
        this.project = task.getProject();
        this.task = task;
        this.initialize();
    }

    public AntLogger(Target target) {
        this.project = target.getProject();
        this.target = target;
        this.initialize();
    }

    public AntLogger(Project project) {
        this.project = project;
        this.initialize();
    }

    private void initialize() {
        this.levelMapper = new HashMap<LogLevel, Integer>();
        this.levelMapper.put(LogLevel.DEBUG, new Integer(4));
        this.levelMapper.put(LogLevel.WARN, new Integer(1));
        this.levelMapper.put(LogLevel.INFO, new Integer(2));
    }

    @Override
    protected void doLog(LogLevel level, String message, String category) {
        Integer antLogLevel = this.levelMapper.get(level);
        if (antLogLevel == null) {
            throw new IllegalStateException("No ANT log level for CARGO LogLevel " + level);
        }
        if (this.task != null) {
            this.project.log(this.task, message, (int)antLogLevel);
        } else if (this.target != null) {
            this.project.log(this.target, message, (int)antLogLevel);
        } else {
            this.project.log(message, antLogLevel);
        }
    }
}

