/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.ejb.Entity;
import org.codehaus.cargo.module.ejb.Session;
import org.codehaus.cargo.module.ejb.VendorEjbDescriptor;
import org.jdom.Attribute;
import org.jdom.Element;

public class EjbJarXml
extends AbstractDescriptor
implements J2eeDescriptor {
    private List<Descriptor> vendorDescriptors = new ArrayList<Descriptor>();

    public EjbJarXml(Element rootElement, DescriptorType type) {
        super(rootElement, type);
    }

    @Override
    public String getFileName() {
        return "ejb-jar.xml";
    }

    public void addVendorDescriptor(VendorEjbDescriptor descr) {
        this.vendorDescriptors.add(descr);
    }

    @Override
    public List<Descriptor> getVendorDescriptors() {
        return this.vendorDescriptors;
    }

    public List<Session> getSessionEjbs() {
        ArrayList<Session> ejbs = new ArrayList<Session>();
        for (Element sessionElement : this.getElements("session")) {
            Session session = new Session();
            Attribute id = sessionElement.getAttribute("id");
            if (id != null) {
                session.setId(id.getValue());
            }
            session.setName(this.getChildText(sessionElement, "ejb-name"));
            session.setLocal(this.getChildText(sessionElement, "local"));
            session.setLocalHome(this.getChildText(sessionElement, "local-home"));
            ejbs.add(session);
        }
        return ejbs;
    }

    public List<Entity> getEntityEjbs() {
        ArrayList<Entity> ejbs = new ArrayList<Entity>();
        for (Element entityElement : this.getElements("entity")) {
            Entity entity = new Entity();
            Attribute id = entityElement.getAttribute("id");
            if (id != null) {
                entity.setId(id.getValue());
            }
            entity.setName(this.getChildText(entityElement, "ejb-name"));
            entity.setLocal(this.getChildText(entityElement, "local"));
            entity.setLocalHome(this.getChildText(entityElement, "local-home"));
            ejbs.add(entity);
        }
        return ejbs;
    }

    public Session getSessionEjb(String name) {
        Session result = null;
        for (Session ejb : this.getSessionEjbs()) {
            if (!ejb.getName().equals(name)) continue;
            result = ejb;
            break;
        }
        return result;
    }

    public Entity getEntityEjb(String name) {
        Entity result = null;
        for (Entity ejb : this.getEntityEjbs()) {
            if (!ejb.getName().equals(name)) continue;
            result = ejb;
            break;
        }
        return result;
    }
}

