/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.util.CargoException;

public final class WildFlyUserUtils {
    private WildFlyUserUtils() {
    }

    public static String generateUserPasswordLine(User user, String realm) {
        byte[] hash;
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CargoException("Cannot get the MD5 digest for generating the JBoss user properties files", e);
        }
        String toHash = user.getName() + ":" + realm + ":" + user.getPassword();
        try {
            hash = md5.digest(toHash.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CargoException("Cannot encode one line for the application-users.properties file", e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(user.getName());
        sb.append("=");
        for (byte hashByte : hash) {
            sb.append(String.format("%02x", hashByte));
        }
        sb.append('\n');
        return sb.toString();
    }
}

