/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal.configuration.factory;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.configuration.script.ScriptCommand;
import org.codehaus.cargo.container.property.TransactionSupport;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.custom.CustomWildFlyScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.domain.ConfigurePortsScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.domain.LoggingScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.domain.SystemPropertyScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource.DataSourceScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource.DriverScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource.JmsQueueScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource.JmsTopicScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource.MailScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource.XaDataSourceScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource.XaDriverScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.server.BatchScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.server.RunBatchScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.server.StartEmbedServerScriptCommand;
import org.codehaus.cargo.container.wildfly.internal.configuration.factory.WildFly8xCliConfigurationFactory;
import org.codehaus.cargo.util.CargoException;

public class WildFly9xCliConfigurationFactory
extends WildFly8xCliConfigurationFactory {
    private static Map<String, Class<? extends ScriptCommand>> resourceMap = new HashMap<String, Class<? extends ScriptCommand>>();
    private static final String RESOURCE_PATH = "org/codehaus/cargo/container/internal/resources/wildfly-9/cli/";

    public WildFly9xCliConfigurationFactory(Configuration configuration) {
        super(configuration);
    }

    public ScriptCommand startEmbedServerScript() {
        return new StartEmbedServerScriptCommand(this.configuration, RESOURCE_PATH);
    }

    public ScriptCommand batchScript() {
        return new BatchScriptCommand(this.configuration, RESOURCE_PATH);
    }

    public ScriptCommand runBatchScript() {
        return new RunBatchScriptCommand(this.configuration, RESOURCE_PATH);
    }

    public ScriptCommand configurePortsScript() {
        return new ConfigurePortsScriptCommand(this.configuration, RESOURCE_PATH);
    }

    public ScriptCommand loggingScript() {
        return new LoggingScriptCommand(this.configuration, RESOURCE_PATH);
    }

    public ScriptCommand systemPropertyScript(String name, String value) {
        return new SystemPropertyScriptCommand(this.configuration, RESOURCE_PATH, name, value);
    }

    public ScriptCommand dataSourceScript(DataSource ds) {
        if ("javax.sql.XADataSource".equals(ds.getConnectionType())) {
            return new XaDataSourceScriptCommand(this.configuration, RESOURCE_PATH, ds);
        }
        return new DataSourceScriptCommand(this.configuration, RESOURCE_PATH, ds);
    }

    public ScriptCommand dataSourceDriverScript(DataSource ds, String driverModule) {
        if (TransactionSupport.XA_TRANSACTION.equals(ds.getTransactionSupport())) {
            return new XaDriverScriptCommand(this.configuration, RESOURCE_PATH, ds, driverModule);
        }
        return new DriverScriptCommand(this.configuration, RESOURCE_PATH, ds, driverModule);
    }

    public ScriptCommand resourceScript(Resource resource) {
        Class<? extends ScriptCommand> resourceClass = resourceMap.get(resource.getType());
        if (resourceClass == null) {
            throw new CargoException("Resources of type " + resource.getType() + " are not supported by the WildFly CLI configuration factory.");
        }
        ScriptCommand newInstance = null;
        try {
            newInstance = resourceClass.getConstructor(Configuration.class, String.class, Resource.class).newInstance(this.configuration, RESOURCE_PATH, resource);
        }
        catch (Exception e) {
            throw new CargoException("Failed instantiation of resource command.", e);
        }
        return newInstance;
    }

    public ScriptCommand customScript(String scriptPath) {
        return new CustomWildFlyScriptCommand(scriptPath);
    }

    static {
        resourceMap.put("javax.jms.Queue", JmsQueueScriptCommand.class);
        resourceMap.put("javax.jms.Topic", JmsTopicScriptCommand.class);
        resourceMap.put("javax.mail.Session", MailScriptCommand.class);
    }
}

