/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly9.resource;

import java.util.Map;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.AbstractWildFlyScriptCommand;

public class MailScriptCommand
extends AbstractWildFlyScriptCommand {
    private Resource resource;

    public MailScriptCommand(Configuration configuration, String resourcePath, Resource resource) {
        super(configuration, resourcePath);
        this.resource = resource;
    }

    @Override
    protected String getScriptRelativePath() {
        return "resource/mail.cli";
    }

    @Override
    protected void addConfigurationScriptProperties(Map<String, String> propertiesMap) {
        propertiesMap.put("cargo.resource.id", this.resource.getId());
        propertiesMap.put("cargo.resource.name", this.getResourceJndi(this.resource));
        StringBuffer sessionParameters = new StringBuffer();
        if (this.resource.getParameter("mail.smtp.from") != null) {
            sessionParameters.append("from=");
            sessionParameters.append(this.resource.getParameter("mail.smtp.from"));
        }
        propertiesMap.put("cargo.mail.session.parameters", sessionParameters.toString());
        String host = this.resource.getParameter("mail.smtp.host") != null ? this.resource.getParameter("mail.smtp.host") : "localhost";
        String port = this.resource.getParameter("mail.smtp.port") != null ? this.resource.getParameter("mail.smtp.port") : "25";
        propertiesMap.put("cargo.mail.smtp.host", host);
        propertiesMap.put("cargo.mail.smtp.port", port);
    }
}

