/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal.configuration.commands.wildfly8.server;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.internal.util.ComplexPropertyUtils;
import org.codehaus.cargo.container.wildfly.internal.configuration.commands.AbstractWildFlyScriptCommand;

public class AddModuleScriptCommand
extends AbstractWildFlyScriptCommand {
    private String moduleName;
    private List<String> jarFilePaths;
    private List<String> moduleDependencies;

    public AddModuleScriptCommand(Configuration configuration, String resourcePath, String moduleName, List<String> jarFilePaths, List<String> moduleDependencies) {
        super(configuration, resourcePath);
        this.moduleName = moduleName;
        this.jarFilePaths = jarFilePaths;
        this.moduleDependencies = moduleDependencies;
    }

    @Override
    protected String getScriptRelativePath() {
        return "server/add-module.cli";
    }

    @Override
    protected void addConfigurationScriptProperties(Map<String, String> propertiesMap) {
        propertiesMap.put("cargo.wildfly.module.name", this.moduleName);
        char delimiter = File.pathSeparatorChar;
        String resources = ComplexPropertyUtils.joinOnDelimiter(this.jarFilePaths, delimiter);
        propertiesMap.put("cargo.wildfly.module.resources", resources);
        delimiter = ',';
        String depProp = ComplexPropertyUtils.joinOnDelimiter(this.moduleDependencies, delimiter);
        propertiesMap.put("cargo.wildfly.module.dependencies", depProp);
    }
}

