/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal;

import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.internal.http.HttpResult;
import org.codehaus.cargo.util.CargoException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class WildFlyRemoteDeploymentJsonMarshaller {
    private JSONParser parser = new JSONParser();

    public String unmarshallAddContentResponse(HttpResult response) {
        JSONObject obj;
        String responseBody = response.getResponseBody();
        if (responseBody == null || responseBody.isEmpty()) {
            throw new CargoException("Response is empty!");
        }
        try {
            obj = (JSONObject)this.parser.parse(responseBody);
        }
        catch (ParseException e) {
            throw new CargoException("Exception during response parsing.", e);
        }
        JSONObject result = (JSONObject)obj.get("result");
        String bytesValue = (String)result.get("BYTES_VALUE");
        return bytesValue;
    }

    public String marshallDeployRequest(Deployable deployable, String bytesValue) {
        JSONObject bytesValueObject = new JSONObject();
        bytesValueObject.put("BYTES_VALUE", bytesValue);
        JSONObject hashObject = new JSONObject();
        hashObject.put("hash", bytesValueObject);
        JSONObject deploymentObject = new JSONObject();
        deploymentObject.put("deployment", deployable.getName() + "." + deployable.getType().getType());
        JSONObject deployRequest = new JSONObject();
        deployRequest.put("content", this.wrapInArray(hashObject));
        deployRequest.put("address", this.wrapInArray(deploymentObject));
        deployRequest.put("operation", "add");
        deployRequest.put("enabled", "true");
        return deployRequest.toJSONString();
    }

    public String marshallUndeployRequest(Deployable deployable) {
        JSONObject deploymentObject = new JSONObject();
        deploymentObject.put("deployment", deployable.getName() + "." + deployable.getType().getType());
        JSONObject deployRequest = new JSONObject();
        deployRequest.put("address", this.wrapInArray(deploymentObject));
        deployRequest.put("operation", "undeploy");
        return deployRequest.toJSONString();
    }

    public String marshallRemoveRequest(Deployable deployable) {
        JSONObject deploymentObject = new JSONObject();
        deploymentObject.put("deployment", deployable.getName() + "." + deployable.getType().getType());
        JSONObject deployRequest = new JSONObject();
        deployRequest.put("address", this.wrapInArray(deploymentObject));
        deployRequest.put("operation", "remove");
        return deployRequest.toJSONString();
    }

    private JSONArray wrapInArray(JSONObject ... jsonObjects) {
        JSONArray array = new JSONArray();
        for (JSONObject object : jsonObjects) {
            array.add(object);
        }
        return array;
    }
}

