/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.internal.http.HttpConnection;
import org.codehaus.cargo.container.internal.http.HttpResult;
import org.codehaus.cargo.container.internal.http.request.HttpFormRequest;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;
import org.codehaus.cargo.container.wildfly.internal.WildFlyRemoteDeploymentJsonMarshaller;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractWildFlyRemoteDeployer
extends AbstractRemoteDeployer {
    private WildFlyRemoteDeploymentJsonMarshaller marshaller;
    private String username;
    private String password;
    private String hostname;
    private int managementPort;

    public AbstractWildFlyRemoteDeployer(RemoteContainer container) {
        super(container);
        RuntimeConfiguration configuration = container.getConfiguration();
        this.marshaller = new WildFlyRemoteDeploymentJsonMarshaller();
        this.username = configuration.getPropertyValue("cargo.remote.username");
        this.password = configuration.getPropertyValue("cargo.remote.password");
        this.hostname = configuration.getPropertyValue("cargo.hostname");
        String managementPort = configuration.getPropertyValue("cargo.jboss.management-http.port");
        this.managementPort = Integer.valueOf(managementPort);
    }

    @Override
    public void deploy(Deployable deployable) {
        String bytesValue = this.uploadDeployable(deployable);
        this.deployDeployable(deployable, bytesValue);
    }

    @Override
    public void undeploy(Deployable deployable) {
        this.undeployDeployable(deployable);
        this.removeDeployable(deployable);
    }

    private String uploadDeployable(Deployable deployable) {
        URL addContentUrl = this.getAddContentUrl();
        String deploymentName = deployable.getName() + "." + deployable.getType().getType();
        HttpFormRequest formRequest = new HttpFormRequest(addContentUrl);
        formRequest.setAuthentication(this.username, this.password);
        StringBuffer sb = new StringBuffer();
        sb.append("Content-Disposition: form-data; ");
        sb.append("name=\"file\"; ");
        sb.append("filename=\"" + deploymentName + "\"");
        HttpResult response = formRequest.execute(sb.toString(), deployable.getFile());
        this.verifyResponse(response);
        return this.marshaller.unmarshallAddContentResponse(response);
    }

    private void deployDeployable(Deployable deployable, String bytesValue) {
        URL managementUrl = this.getManagementUrl();
        String deployRequest = this.marshaller.marshallDeployRequest(deployable, bytesValue);
        HttpConnection connection = new HttpConnection(managementUrl);
        connection.addRequestProperty("Content-Type", "application/json");
        connection.setAuthentication(this.username, this.password);
        connection.setRequestBody(deployRequest);
        HttpResult response = connection.post();
        this.verifyResponse(response);
    }

    private void undeployDeployable(Deployable deployable) {
        URL managementUrl = this.getManagementUrl();
        String undeployRequest = this.marshaller.marshallUndeployRequest(deployable);
        HttpConnection connection = new HttpConnection(managementUrl);
        connection.addRequestProperty("Content-Type", "application/json");
        connection.setAuthentication(this.username, this.password);
        connection.setRequestBody(undeployRequest);
        HttpResult response = connection.post();
        this.verifyResponse(response);
    }

    private void removeDeployable(Deployable deployable) {
        URL managementUrl = this.getManagementUrl();
        String removeRequest = this.marshaller.marshallRemoveRequest(deployable);
        HttpConnection connection = new HttpConnection(managementUrl);
        connection.addRequestProperty("Content-Type", "application/json");
        connection.setAuthentication(this.username, this.password);
        connection.setRequestBody(removeRequest);
        HttpResult response = connection.post();
        this.verifyResponse(response);
    }

    private URL getAddContentUrl() {
        try {
            return new URL("http", this.hostname, this.managementPort, "/management/add-content");
        }
        catch (MalformedURLException e) {
            throw new CargoException("Error while trying to create URL.", e);
        }
    }

    private URL getManagementUrl() {
        try {
            return new URL("http", this.hostname, this.managementPort, "/management");
        }
        catch (MalformedURLException e) {
            throw new CargoException("Error while trying to create URL.", e);
        }
    }

    private void verifyResponse(HttpResult response) {
        if (!response.isSuccessful()) {
            throw new CargoException("HTTP request failed, response code: " + response.getResponseCode() + ", response message: " + response.getResponseMessage() + ", response body: " + response.getResponseBody());
        }
    }
}

