/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.wildfly.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ScriptingCapableContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.script.ScriptCommand;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.jboss.internal.JBoss7xContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.container.wildfly.internal.WildFlyConfiguration;
import org.codehaus.cargo.container.wildfly.internal.configuration.factory.WildFlyCliConfigurationFactory;
import org.codehaus.cargo.util.CargoException;

public abstract class AbstractWildFlyInstalledLocalContainer
extends AbstractInstalledLocalContainer
implements ScriptingCapableContainer {
    private static final ContainerCapability CAPABILITY = new JBoss7xContainerCapability();
    protected String version;

    public AbstractWildFlyInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    @Override
    public ContainerCapability getCapability() {
        return CAPABILITY;
    }

    @Override
    protected void doStart(JvmLauncher java) throws Exception {
        this.setProperties(java);
        java.addJvmArgumentLine("-D[Standalone]");
        java.setJarFile(new File(this.getHome(), "jboss-modules.jar"));
        String modules = this.getConfiguration().getPropertyValue("cargo.jboss.modules.dir");
        if (!new File(modules).isAbsolute()) {
            modules = this.getFileHandler().append(this.getHome(), modules);
        }
        java.addAppArguments("-mp", modules, "org.jboss.as.standalone", "--server-config=" + this.getConfiguration().getPropertyValue("cargo.jboss.configuration") + ".xml");
        String runtimeArgs = this.getConfiguration().getPropertyValue("cargo.runtime.args");
        if (runtimeArgs != null) {
            runtimeArgs = runtimeArgs.replace('\n', ' ');
            runtimeArgs = runtimeArgs.replace('\r', ' ');
            runtimeArgs = runtimeArgs.replace('\t', ' ');
            java.addAppArgumentLine(runtimeArgs);
        }
        java.start();
    }

    protected void setProperties(JvmLauncher java) {
        java.setSystemProperty("org.jboss.boot.log.file", this.getConfiguration().getHome() + "/log/boot.log");
        try {
            java.setSystemProperty("logging.configuration", new File(this.getConfiguration().getHome() + "/configuration/logging.properties").toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            throw new CargoException("Cannot create logging file URL.", e);
        }
        java.setEnvironmentVariable("JBOSS_HOME", this.getHome());
        java.setSystemProperty("jboss.home.dir", this.getHome());
        java.setSystemProperty("jboss.server.base.dir", this.getConfiguration().getHome());
        java.setSystemProperty("jboss.server.config.dir", this.getConfiguration().getHome() + File.separator + "configuration");
        java.setSystemProperty("jboss.server.data.dir", this.getConfiguration().getHome() + File.separator + "data");
        java.setSystemProperty("jboss.server.log.dir", this.getConfiguration().getHome() + File.separator + "log");
        java.setSystemProperty("jboss.server.temp.dir", this.getConfiguration().getHome() + File.separator + "tmp");
        java.setSystemProperty("jboss.server.deploy.dir", this.getConfiguration().getHome() + File.separator + "content");
        Map<String, String> systemProperties = this.getSystemProperties();
        if (!systemProperties.containsKey("jboss.bind.address")) {
            String hostname = this.getConfiguration().getPropertyValue("cargo.hostname");
            if ("localhost".equals(hostname)) {
                hostname = "0.0.0.0";
            }
            java.setSystemProperty("jboss.bind.address", hostname);
        }
    }

    @Override
    protected void doStop(JvmLauncher java) throws Exception {
        ArrayList<ScriptCommand> configurationScript = new ArrayList<ScriptCommand>();
        WildFlyConfiguration configuration = (WildFlyConfiguration)((Object)this.getConfiguration());
        WildFlyCliConfigurationFactory factory = configuration.getConfigurationFactory();
        configurationScript.add(factory.shutdownServerScript());
        this.executeScript(configurationScript);
    }

    @Override
    public void executeScript(List<ScriptCommand> configurationScript) {
        String newLine = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        for (ScriptCommand configuration : configurationScript) {
            buffer.append(configuration.readScript());
            buffer.append(newLine);
        }
        this.getLogger().debug("Sending CLI script: " + newLine + buffer.toString(), this.getClass().getName());
        try {
            File tempFile = File.createTempFile("wildfly-", ".cli");
            tempFile.deleteOnExit();
            this.getFileHandler().writeTextFile(tempFile.getAbsolutePath(), buffer.toString(), null);
            this.executeScriptFiles(Arrays.asList(tempFile.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new CargoException("Cannot create temporary CLI script file.", e);
        }
    }

    @Override
    public void executeScriptFiles(List<String> scriptFilePaths) {
        for (String scriptFilePath : scriptFilePaths) {
            File scriptFile = new File(scriptFilePath);
            if (scriptFile.isAbsolute() && !scriptFile.exists()) {
                this.getLogger().warn(String.format("Script file %s doesn't exists.", scriptFilePath), this.getClass().getName());
                continue;
            }
            JvmLauncher java = this.createJvmLauncher(false);
            this.addCliArguments(java);
            this.setProperties(java);
            java.addAppArguments("--file=" + scriptFile);
            int result = java.execute();
            if (result == 0) continue;
            throw new ContainerException("Failure when invoking CLI script, java returned " + result);
        }
    }

    private void addCliArguments(JvmLauncher java) {
        String host = this.getConfiguration().getPropertyValue("cargo.hostname");
        String port = this.getConfiguration().getPropertyValue("cargo.jboss.management-http.port");
        java.setJarFile(new File(this.getHome(), "jboss-modules.jar"));
        String modules = this.getConfiguration().getPropertyValue("cargo.jboss.modules.dir");
        if (!new File(modules).isAbsolute()) {
            modules = this.getFileHandler().append(this.getHome(), modules);
        }
        java.addAppArguments("-mp", modules, "org.jboss.as.cli");
        if (this.isOnline()) {
            java.addAppArguments("--connect", "--controller=" + host + ":" + port);
        }
    }

    protected String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                File configAdminFile = null;
                File configAdminDirectory = this.getConfigAdminDirectory();
                if (configAdminDirectory.isDirectory()) {
                    File[] contents;
                    for (File content : contents = configAdminDirectory.listFiles()) {
                        if (!content.getName().endsWith(".jar")) continue;
                        if (configAdminFile != null) {
                            throw new IllegalStateException("The directory " + configAdminDirectory + " contains more than one JAR.");
                        }
                        configAdminFile = content;
                    }
                    if (configAdminFile == null) {
                        throw new IllegalStateException("The directory " + configAdminDirectory + " does not contain any JAR files.");
                    }
                } else {
                    throw new IllegalArgumentException(configAdminDirectory + " is not a directory.");
                }
                JarFile jarFile = new JarFile(configAdminFile);
                version = jarFile.getManifest().getMainAttributes().getValue("Bundle-Version");
                if (version == null) {
                    version = jarFile.getManifest().getMainAttributes().getValue("Implementation-Version");
                }
                jarFile.close();
                if (version == null) {
                    version = defaultVersion;
                    this.getLogger().debug("Couldn't find Bundle-Version in the MANIFEST of " + configAdminFile, this.getClass().getName());
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getLogger().debug("Failed to find JBoss version, base error [" + e.getMessage() + "]", this.getClass().getName());
            }
            this.getLogger().info("Parsed JBoss version = [" + version + "]", this.getClass().getName());
            this.version = version;
        }
        return version;
    }

    protected File getConfigAdminDirectory() {
        return new File(this.getHome(), "modules/system/layers/base/org/jboss/as/system-jmx/main");
    }

    public boolean isOnline() {
        HttpUtils httpUtils = new HttpUtils();
        return httpUtils.ping(ContainerUtils.getCPCURL(this.getConfiguration()));
    }

    @Override
    protected void addRuntimeArgs(JvmLauncher java) {
    }
}

