/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.spi.configuration.AbstractLocalConfiguration;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.XmlReplacement;

public abstract class AbstractStandaloneLocalConfiguration
extends AbstractLocalConfiguration
implements StandaloneLocalConfiguration {
    private Map<String, Map<FileHandler.XmlReplacementDetails, String>> xmlReplacements;

    public AbstractStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.logging", LoggingLevel.MEDIUM.getLevel());
        this.xmlReplacements = new HashMap<String, Map<FileHandler.XmlReplacementDetails, String>>();
    }

    protected void performXmlReplacements(LocalContainer container) {
        Boolean ignoreNonExistingProperties = Boolean.valueOf(this.getPropertyValue("cargo.standalone.ignoreNonExistingProperties"));
        for (Map.Entry<String, Map<FileHandler.XmlReplacementDetails, String>> xmlReplacementDetails : this.xmlReplacements.entrySet()) {
            HashSet<XmlReplacement> replacements = new HashSet<XmlReplacement>();
            String destinationFile = this.getFileHandler().append(container.getConfiguration().getHome(), xmlReplacementDetails.getKey());
            for (Map.Entry<FileHandler.XmlReplacementDetails, String> xmlReplacementDetail : xmlReplacementDetails.getValue().entrySet()) {
                XmlReplacement xmlReplacement;
                String value = container.getConfiguration().getPropertyValue(xmlReplacementDetail.getValue());
                if (value == null) {
                    value = xmlReplacementDetail.getValue();
                }
                if ((xmlReplacement = new XmlReplacement(destinationFile, xmlReplacementDetail.getKey().getXpathExpression(), xmlReplacementDetail.getKey().getAttributeName(), xmlReplacementDetail.getKey().isIgnoreIfNonExisting(), value)).isIgnoreIfNonExisting() == null) {
                    xmlReplacement.setIgnoreIfNonExisting(ignoreNonExistingProperties);
                }
                replacements.add(xmlReplacement);
            }
            if (replacements.isEmpty()) continue;
            XmlReplacement[] replacementsArray = new XmlReplacement[replacements.size()];
            replacementsArray = replacements.toArray(replacementsArray);
            this.getFileHandler().replaceInXmlFile(replacementsArray);
        }
    }

    protected void setupConfigurationDir() throws IOException {
        String timestampFile = this.getFileHandler().append(this.getHome(), ".cargo");
        if (!(this.getFileHandler().exists(timestampFile) || this.getFileHandler().exists(this.getHome()) && this.getFileHandler().isDirectoryEmpty(this.getHome()) || !this.getFileHandler().exists(this.getHome()))) {
            throw new ContainerException("Invalid configuration dir [" + this.getHome() + "]. When using standalone configurations, the configuration dir must point to an empty directory. Note that everything in that dir will get deleted by Cargo.");
        }
        this.getFileHandler().delete(this.getHome());
        this.getFileHandler().mkdirs(this.getHome());
        this.getFileHandler().createFile(timestampFile);
    }

    @Override
    public void addXmlReplacement(XmlReplacement xmlReplacement) {
        Map<FileHandler.XmlReplacementDetails, String> fileReplacements = this.xmlReplacements.get(xmlReplacement.getFile());
        if (fileReplacements == null) {
            fileReplacements = new HashMap<FileHandler.XmlReplacementDetails, String>();
            this.xmlReplacements.put(xmlReplacement.getFile(), fileReplacements);
        }
        fileReplacements.put(new FileHandler.XmlReplacementDetails(xmlReplacement.getXpathExpression(), xmlReplacement.getAttributeName(), xmlReplacement.isIgnoreIfNonExisting()), xmlReplacement.getValue());
    }

    @Override
    public void addXmlReplacement(String filename, String xpathExpression, String configurationPropertyName) {
        this.addXmlReplacement(filename, xpathExpression, null, configurationPropertyName);
    }

    @Override
    public void addXmlReplacement(String filename, String xpathExpression, String attributeName, String configurationPropertyName) {
        Map<FileHandler.XmlReplacementDetails, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements == null) {
            fileReplacements = new HashMap<FileHandler.XmlReplacementDetails, String>();
            this.xmlReplacements.put(filename, fileReplacements);
        }
        fileReplacements.put(new FileHandler.XmlReplacementDetails(xpathExpression, attributeName, null), configurationPropertyName);
    }

    @Override
    public void addXmlReplacement(String filename, String xpathExpression, String attributeName, String configurationPropertyName, boolean ignoreIfNonExisting) {
        Map<FileHandler.XmlReplacementDetails, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements == null) {
            fileReplacements = new HashMap<FileHandler.XmlReplacementDetails, String>();
            this.xmlReplacements.put(filename, fileReplacements);
        }
        fileReplacements.put(new FileHandler.XmlReplacementDetails(xpathExpression, attributeName, ignoreIfNonExisting), configurationPropertyName);
    }

    @Override
    public void removeXmlReplacement(String filename, String xpathExpression) {
        this.removeXmlReplacement(filename, xpathExpression, null);
    }

    @Override
    public void removeXmlReplacement(String filename, String xpathExpression, String attributeName) {
        Map<FileHandler.XmlReplacementDetails, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements != null) {
            fileReplacements.remove(new FileHandler.XmlReplacementDetails(xpathExpression, attributeName, null));
            if (fileReplacements.isEmpty()) {
                this.xmlReplacements.remove(filename);
            }
        }
    }

    @Override
    public List<XmlReplacement> getXmlReplacements() {
        ArrayList<XmlReplacement> xmlReplacements = new ArrayList<XmlReplacement>();
        for (Map.Entry<String, Map<FileHandler.XmlReplacementDetails, String>> xmlReplacementEntry : this.xmlReplacements.entrySet()) {
            for (Map.Entry<FileHandler.XmlReplacementDetails, String> xmlReplacementDetail : xmlReplacementEntry.getValue().entrySet()) {
                XmlReplacement xmlReplacement = new XmlReplacement(xmlReplacementEntry.getKey(), xmlReplacementDetail.getKey().getXpathExpression(), xmlReplacementDetail.getKey().getAttributeName(), xmlReplacementDetail.getKey().isIgnoreIfNonExisting(), xmlReplacementDetail.getValue());
                xmlReplacements.add(xmlReplacement);
            }
        }
        return xmlReplacements;
    }

    @Override
    public void verify() {
        super.verify();
        this.verifyLogging();
    }

    private void verifyLogging() {
        String level = this.getPropertyValue("cargo.logging");
        try {
            LoggingLevel.toLevel(level);
        }
        catch (IllegalArgumentException e) {
            throw new ContainerException("Invalid logging level [" + level + "]. Valid levels are {\"low\", \"medium\", \"high\"}");
        }
    }

    @Override
    public ConfigurationType getType() {
        return ConfigurationType.STANDALONE;
    }

    @Override
    protected void configureFiles(FilterChain filterChain, LocalContainer container) {
        this.performXmlReplacements(container);
        super.configureFiles(filterChain, container);
    }

    protected void replaceInFile(String file, Map<String, String> replacements, String encoding) throws CargoException {
        boolean ignoreNonExistingProperties = Boolean.valueOf(this.getPropertyValue("cargo.standalone.ignoreNonExistingProperties"));
        if (replacements.isEmpty()) {
            return;
        }
        String path = this.getHome() + "/" + file;
        this.getFileHandler().replaceInFile(path, replacements, encoding, ignoreNonExistingProperties);
    }
}

