/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.AbstractLocalContainer;
import org.codehaus.cargo.container.spi.jvm.DefaultJvmLauncherFactory;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.container.spi.jvm.JvmLauncherFactory;
import org.codehaus.cargo.container.spi.jvm.JvmLauncherRequest;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractInstalledLocalContainer
extends AbstractLocalContainer
implements InstalledLocalContainer {
    private Map<String, String> systemProperties;
    private List<String> extraClasspath;
    private List<String> sharedClasspath;
    private String home;
    private AntUtils antUtils = new AntUtils();
    private HttpUtils httpUtils;
    private ResourceUtils resourceUtils = new ResourceUtils();
    private JvmLauncherFactory jvmLauncherFactory;
    private JvmLauncher jvmStartLauncher;
    private int jvmMajorVersion = -1;

    public AbstractInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
        this.httpUtils = new HttpUtils();
        this.jvmLauncherFactory = new DefaultJvmLauncherFactory();
        this.extraClasspath = new ArrayList<String>();
        this.sharedClasspath = new ArrayList<String>();
        this.systemProperties = new HashMap<String, String>();
    }

    @Override
    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.resourceUtils.setLogger(logger);
        this.httpUtils.setLogger(logger);
    }

    protected final HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    @Override
    public void setHome(String home) {
        this.home = home;
    }

    @Override
    public void setSystemProperties(Map<String, String> properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(properties);
        this.systemProperties = props;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public void setExtraClasspath(String[] classpath) {
        this.extraClasspath.clear();
        this.extraClasspath.addAll(Arrays.asList(classpath));
    }

    @Override
    public String[] getExtraClasspath() {
        return this.extraClasspath.toArray(new String[0]);
    }

    @Override
    public void setSharedClasspath(String[] classpath) {
        this.sharedClasspath.clear();
        this.sharedClasspath.addAll(Arrays.asList(classpath));
    }

    @Override
    public String[] getSharedClasspath() {
        return this.sharedClasspath.toArray(new String[0]);
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public JvmLauncherFactory getJvmLauncherFactory() {
        return this.jvmLauncherFactory;
    }

    @Override
    public void setJvmLauncherFactory(JvmLauncherFactory jvmLauncherFactory) {
        this.jvmLauncherFactory = jvmLauncherFactory;
    }

    protected abstract void doStart(JvmLauncher var1) throws Exception;

    protected abstract void doStop(JvmLauncher var1) throws Exception;

    @Override
    protected void startInternal() throws Exception {
        this.jvmStartLauncher = this.createJvmLauncher(true);
        if (this.getOutput() != null) {
            this.jvmStartLauncher.setAppendOutput(this.isAppend());
        }
        this.addMemoryArguments(this.jvmStartLauncher);
        this.doStart(this.jvmStartLauncher);
    }

    @Override
    protected void stopInternal() throws Exception {
        this.doStop(this.createJvmLauncher(false));
    }

    @Override
    protected final void forceStopInternal() {
        if (this.jvmStartLauncher != null) {
            this.jvmStartLauncher.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JvmLauncher createJvmLauncher(boolean server) {
        JvmLauncher java;
        JvmLauncherRequest request;
        boolean ssh;
        boolean bl = ssh = this.getConfiguration().getPropertyValue("cargo.ssh.host") != null;
        if (this.jvmMajorVersion == -1) {
            String jvmVersion;
            block19: {
                request = new JvmLauncherRequest(false, this, ssh);
                java = this.jvmLauncherFactory.createJvmLauncher(request);
                if (ssh) {
                    this.addSshProperties(java);
                }
                this.setJvmToLaunchContainerIn(java);
                BufferedReader br = null;
                try {
                    File jvmVersionFile = File.createTempFile("cargo-jvm-version-", ".txt");
                    java.setOutputFile(jvmVersionFile);
                    java.setAppendOutput(true);
                    java.setMainClass("-version");
                    java.start();
                    for (int i = 0; i < 150 && jvmVersionFile.length() <= 0L; ++i) {
                        Thread.sleep(100L);
                    }
                    br = new BufferedReader(new FileReader(jvmVersionFile));
                    jvmVersion = br.readLine();
                    if (jvmVersion != null && jvmVersion.startsWith("java version \"")) {
                        jvmVersion = jvmVersion.substring(jvmVersion.indexOf(34) + 1);
                        break block19;
                    }
                    throw new IOException("Can't read JVM version from line: " + jvmVersion);
                }
                catch (Throwable t) {
                    jvmVersion = System.getProperty("java.version");
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException jvmVersionFile) {}
                        br = null;
                        System.gc();
                    }
                }
            }
            this.jvmMajorVersion = JdkUtils.parseMajorJavaVersion(jvmVersion);
        }
        request = new JvmLauncherRequest(server, this, ssh);
        java = this.jvmLauncherFactory.createJvmLauncher(request);
        java.setWorkingDirectory(new File(this.getFileHandler().getAbsolutePath(this.getConfiguration().getHome())));
        if (ssh) {
            this.addSshProperties(java);
        }
        if (this.getOutput() != null) {
            File outputFile = new File(this.getOutput());
            this.getFileHandler().mkdirs(outputFile.getAbsoluteFile().getParent());
            java.setOutputFile(outputFile);
            java.setAppendOutput(true);
        }
        this.setJvmToLaunchContainerIn(java);
        this.addExtraClasspath(java);
        this.addSystemProperties(java);
        this.addRuntimeArgs(java);
        this.addJvmArgs(java);
        if (server) {
            this.addStartJvmArgs(java);
        }
        this.addSpawn(java);
        return java;
    }

    private void addSshProperties(JvmLauncher java) {
        if (this.getConfiguration().getDeployables() != null) {
            for (Deployable toDeploy : this.getConfiguration().getDeployables()) {
                java.setSystemProperty("sshjava.shift." + this.getFileHandler().getAbsolutePath(toDeploy.getFile()), "deployables/" + new File(toDeploy.getFile()).getName());
            }
        }
        if (this.getHome() != null) {
            java.setSystemProperty("sshjava.shift." + this.getFileHandler().getAbsolutePath(this.getHome()), "containers/" + this.getId());
        }
        Properties properties = new Properties();
        properties.put("sshjava.username", "cargo.ssh.username");
        properties.put("sshjava.host", "cargo.ssh.host");
        properties.put("sshjava.password", "cargo.ssh.password");
        properties.put("sshjava.keyfile", "cargo.ssh.keyfile");
        properties.put("sshjava.remotebase", "cargo.ssh.remotebase");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            java.setSystemProperty(entry.getKey().toString(), this.getConfiguration().getPropertyValue(entry.getValue().toString()));
        }
    }

    protected String getJavaHome() {
        String javaHome = this.getConfiguration().getPropertyValue("cargo.java.home");
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        return javaHome;
    }

    protected void setJvmToLaunchContainerIn(JvmLauncher java) {
        String javaHome = this.getJavaHome();
        if (javaHome != null) {
            String binDir = this.getFileHandler().append(javaHome, "bin");
            String javaPath = this.getFileHandler().append(binDir, "java");
            if (Os.isFamily("windows")) {
                javaPath = javaPath + ".exe";
            }
            java.setJvm(javaPath);
        }
    }

    private void addSystemProperties(JvmLauncher java) {
        for (Map.Entry<String, String> systemProperty : this.getSystemProperties().entrySet()) {
            java.setSystemProperty(systemProperty.getKey(), systemProperty.getValue());
        }
    }

    protected final void addToolsJarToClasspath(JvmLauncher java) throws FileNotFoundException {
        if (!JdkUtils.isOSX() && this.jvmMajorVersion < 9) {
            java.addClasspathEntries(JdkUtils.getToolsJar(this.getJavaHome()));
        }
    }

    protected void addExtraClasspath(JvmLauncher java) {
        if (this.extraClasspath.size() > 0) {
            for (String extraClasspathItem : this.extraClasspath) {
                java.addClasspathEntries(extraClasspathItem);
                this.getLogger().debug("Adding [" + extraClasspathItem + "] to execution classpath", this.getClass().getName());
            }
        }
    }

    protected void addRuntimeArgs(JvmLauncher java) {
        String runtimeArgs = this.getConfiguration().getPropertyValue("cargo.runtime.args");
        if (runtimeArgs != null) {
            runtimeArgs = runtimeArgs.replace('\n', ' ');
            runtimeArgs = runtimeArgs.replace('\r', ' ');
            runtimeArgs = runtimeArgs.replace('\t', ' ');
            java.addAppArgumentLine(runtimeArgs);
        }
    }

    private void addJvmArgs(JvmLauncher java) {
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            jvmargs = jvmargs.replace('\n', ' ');
            jvmargs = jvmargs.replace('\r', ' ');
            jvmargs = jvmargs.replace('\t', ' ');
            java.addJvmArgumentLine(jvmargs);
        }
    }

    private void addStartJvmArgs(JvmLauncher java) {
        String jvmargs = this.getConfiguration().getPropertyValue("cargo.start.jvmargs");
        if (jvmargs != null) {
            jvmargs = jvmargs.replace('\n', ' ');
            jvmargs = jvmargs.replace('\r', ' ');
            jvmargs = jvmargs.replace('\t', ' ');
            java.addJvmArgumentLine(jvmargs);
        }
    }

    protected void addMemoryArguments(JvmLauncher java) {
        String jvmArgs = this.getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmArgs == null || !jvmArgs.contains("-Xms")) {
            java.addJvmArguments("-Xms128m");
        }
        if (jvmArgs == null || !jvmArgs.contains("-Xmx")) {
            java.addJvmArguments("-Xmx512m");
        }
        if (this.jvmMajorVersion < 8) {
            if (jvmArgs == null || !jvmArgs.contains("-XX:PermSize")) {
                java.addJvmArguments("-XX:PermSize=48m");
            }
            if (jvmArgs == null || !jvmArgs.contains("-XX:MaxPermSize")) {
                java.addJvmArguments("-XX:MaxPermSize=128m");
            }
        }
    }

    private void addSpawn(JvmLauncher java) {
        boolean spawnProcess = Boolean.parseBoolean(this.getConfiguration().getPropertyValue("cargo.process.spawn"));
        if (spawnProcess) {
            if (this.getOutput() == null) {
                java.setSpawn(spawnProcess);
            } else {
                this.getLogger().warn("Process cannot be spawned unless output is null", this.getClass().getName());
            }
        }
    }

    @Override
    protected void verify() {
        super.verify();
        this.verifyHome();
    }

    private void verifyHome() {
        if (this.getHome() == null) {
            throw new ContainerException("You must set the mandatory [home] property");
        }
        if (!this.getFileHandler().isDirectory(this.getHome())) {
            throw new ContainerException("[" + this.getHome() + "] is not a directory. It must point to the container home directory.");
        }
    }

    @Override
    public ContainerType getType() {
        return ContainerType.INSTALLED;
    }

    @Override
    public void addExtraClasspath(String location) {
        this.ifPresentAddPathToList(location, this.extraClasspath);
    }

    @Override
    public void addSharedClasspath(String location) {
        this.ifPresentAddPathToList(location, this.sharedClasspath);
    }

    public void ifPresentAddPathToList(String location, List<String> list) {
        if (location == null || !this.getFileHandler().exists(location) || this.getFileHandler().isDirectory(location)) {
            throw new IllegalArgumentException("Invalid file path: " + location);
        }
        list.add(location);
    }
}

