/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss.internal;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.util.log.Logger;

public class UsernamePasswordCallbackHandler
implements CallbackHandler {
    private Logger logger;
    private String username;
    private String password;

    public UsernamePasswordCallbackHandler(Configuration configuration) {
        this.logger = configuration.getLogger();
        this.username = configuration.getPropertyValue("cargo.remote.username");
        this.password = configuration.getPropertyValue("cargo.remote.password");
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            String error;
            if (callback instanceof RealmCallback) {
                RealmCallback realmCallback = (RealmCallback)callback;
                String defaultText = realmCallback.getDefaultText();
                realmCallback.setText(defaultText);
                this.logger.debug("Responded to a RealmCallback", this.getClass().getName());
                continue;
            }
            if (callback instanceof NameCallback) {
                if (this.username == null) {
                    error = "User name not set. Please set it using the \"cargo.remote.username\" option.";
                    this.logger.warn("User name not set. Please set it using the \"cargo.remote.username\" option.", this.getClass().getName());
                    throw new NullPointerException("User name not set. Please set it using the \"cargo.remote.username\" option.");
                }
                ((NameCallback)callback).setName(this.username);
                this.logger.debug("Responded to a NameCallback", this.getClass().getName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (this.password == null) {
                    error = "Password not set. Please set it using the \"cargo.remote.password\" option.";
                    this.logger.warn("Password not set. Please set it using the \"cargo.remote.password\" option.", this.getClass().getName());
                    throw new NullPointerException("Password not set. Please set it using the \"cargo.remote.password\" option.");
                }
                ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                this.logger.debug("Responded to a PasswordCallback", this.getClass().getName());
                continue;
            }
            this.logger.warn("Unsupportted callback " + callback.getClass(), this.getClass().getName());
            throw new UnsupportedCallbackException(callback);
        }
    }
}

