/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss.deployable;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.module.webapp.jboss.JBossWarArchive;

public class JBossWAR
extends WAR {
    private JBossWarArchive warArchive;

    public JBossWAR(String war) {
        super(war);
        try {
            this.warArchive = new JBossWarArchive(new File(this.getFile()));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to parse JBoss WAR file in [" + this.getFile() + "]", e);
        }
    }

    @Override
    public synchronized String getContext() {
        String context = null;
        if (this.warArchive.getJBossWebXml() != null && (context = this.warArchive.getJBossWebXml().getContextRoot()) != null) {
            String virtualHost;
            if ("".equals(context) || "/".equals(context)) {
                context = "ROOT";
            }
            if ((virtualHost = this.warArchive.getJBossWebXml().getVirtualHost()) != null) {
                context = virtualHost + '-' + context;
            }
        }
        if (context == null) {
            context = super.getContext();
        }
        return context;
    }

    public String getVirtualHost() {
        String virtualHost = null;
        if (this.warArchive.getJBossWebXml() != null) {
            virtualHost = this.warArchive.getJBossWebXml().getVirtualHost();
        }
        return virtualHost;
    }

    public boolean containsJBossWebFile() {
        return this.warArchive.getJBossWebXml() != null;
    }

    public boolean containsJBossWebContext() {
        if (this.warArchive.getJBossWebXml() != null) {
            String context = this.warArchive.getJBossWebXml().getContextRoot();
            return context != null;
        }
        return false;
    }
}

