/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableException;
import org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer;

public class JBoss7xInstalledLocalDeployer
extends JBossInstalledLocalDeployer {
    public JBoss7xInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    @Override
    public String getDeployableDir(Deployable deployable) {
        String altDeployDir = this.getContainer().getConfiguration().getPropertyValue("cargo.jboss.deployment.dir");
        if (altDeployDir != null && !"".equals(altDeployDir)) {
            this.getContainer().getLogger().info("Using non-default deployment target directory " + altDeployDir, this.getClass().getName());
            return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), altDeployDir);
        }
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "deployments");
    }

    @Override
    protected void doDeploy(String deployableDir, Deployable deployable) {
        Deployable deployableToDeploy;
        try {
            deployableToDeploy = this.modifyManifestForClasspathEntries(deployable);
        }
        catch (Exception e) {
            throw new DeployableException("Cannot update the MANIFEST of deployable with the JBoss container classpath", e);
        }
        super.doDeploy(deployableDir, deployableToDeploy);
        if (deployableToDeploy.isExpanded()) {
            String deployableName = this.getDeployableName(deployableToDeploy);
            this.getFileHandler().createFile(this.getFileHandler().append(deployableDir, deployableName + ".dodeploy"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Deployable modifyManifestForClasspathEntries(Deployable originalDeployable) throws Exception {
        String moduleName;
        InstalledLocalContainer container = (InstalledLocalContainer)this.getContainer();
        TreeSet<String> classpath = new TreeSet<String>();
        if (container.getExtraClasspath() != null && container.getExtraClasspath().length != 0) {
            for (String classpathElement : container.getExtraClasspath()) {
                moduleName = this.getFileHandler().getName(classpathElement);
                moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
                moduleName = moduleName.replace('.', '-');
                classpath.add(moduleName);
            }
        }
        if (container.getSharedClasspath() != null && container.getSharedClasspath().length != 0) {
            for (String classpathElement : container.getSharedClasspath()) {
                moduleName = this.getFileHandler().getName(classpathElement);
                moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
                moduleName = moduleName.replace('.', '-');
                classpath.add(moduleName);
            }
        }
        if (classpath.isEmpty()) {
            return originalDeployable;
        }
        if (classpath.size() > 0 && originalDeployable.isExpanded()) {
            this.getLogger().warn("The extra classpath and shared classpath options are not supported with expanded deployables on " + container.getId(), this.getClass().getName());
            return originalDeployable;
        }
        String outputFile = this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "tmp/cargo");
        this.getFileHandler().mkdirs(outputFile);
        outputFile = this.getFileHandler().append(outputFile, this.getDeployableName(originalDeployable));
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(originalDeployable.getFile()));
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFile));
            try {
                ZipEntry entry = zin.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                        Manifest manifest = new Manifest(zin);
                        String dependencies = manifest.getMainAttributes().getValue("Dependencies");
                        if (dependencies == null) {
                            dependencies = "";
                        }
                        for (String classpathEntry : classpath) {
                            if (dependencies.contains(classpathEntry)) continue;
                            if (!dependencies.isEmpty()) {
                                dependencies = dependencies + ", ";
                            }
                            dependencies = dependencies + "org.codehaus.cargo.classpath." + classpathEntry;
                        }
                        manifest.getMainAttributes().putValue("Dependencies", dependencies);
                        out.putNextEntry(new ZipEntry(name));
                        manifest.write(out);
                        out.closeEntry();
                    } else {
                        int len;
                        out.putNextEntry(new ZipEntry(name));
                        while ((len = zin.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    entry = zin.getNextEntry();
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            zin.close();
        }
        return (Deployable)originalDeployable.getClass().getConstructor(String.class).newInstance(outputFile);
    }
}

